/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.chain;

import com.atlassian.bamboo.build.BuildStatusHelper;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.chains.ChainFilteredTestResults;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.branches.BranchStatusService;
import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.notification.AbstractNotification;
import com.atlassian.bamboo.notification.ExtendedNotification;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReasonRenderer;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.mail.Email;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class AfterXFailedNotification
extends AbstractNotification
implements ExtendedNotification {
    private static final Logger log = Logger.getLogger(AfterXFailedNotification.class);
    public static final String HTML_EMAIL_TEMPLATE = "notification-templates/AfterXFailedHtmlEmail.ftl";
    public static final String TEXT_EMAIL_TEMPLATE = "notification-templates/AfterXFailedTextEmail.ftl";
    public static final String IM_TEMPLATE = "notification-templates/AfterXFailedIm.ftl";
    public static final String HTML_IM_TEMPLATE = "notification-templates/htmlIm/AfterXFailedHtmlIm.ftl";
    public static final String SUBJECT_TEMPLATE = "notification-templates/AfterXFailedEmailSubject.ftl";
    private String triggerReasonDescription;
    private String firstFailedTriggerReasonDescription;
    private String triggerReasonDescriptionHtml;
    private String firstFailedTriggerReasonDescriptionHtml;
    private Plan plan;
    private ResultsSummary resultsSummary;
    private ResultsSummary firstFailedBuild;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @Inject
    private PlanManager planManager;
    @Inject
    private TriggerManager triggerManager;
    @Inject
    private TemplateRenderer templateRenderer;
    @Inject
    private TestsManager testsManager;
    @Inject
    private TestQuarantineManager testQuarantineManager;
    @Inject
    private BranchStatusService branchStatusService;
    @Inject
    private CustomVariableContext customVariableContext;
    @Inject
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private VcsRepositoryViewerManager vcsRepositoryViewerManager;

    @NotNull
    public Email updateEmail(@NotNull Email email) {
        if (this.plan != null) {
            email.addHeader("X-Bamboo-Plan-Key", this.plan.getKey());
        }
        return email;
    }

    @NotNull
    public String getDescription() {
        return "After X Failed Builds Notification";
    }

    public void init() {
        Object event = this.getPojoEvent();
        if (event != null) {
            ChainCompletedEvent bcEvent = (ChainCompletedEvent)event;
            this.resultsSummary = this.resultsSummaryManager.getResultsSummary(bcEvent.getPlanResultKey());
            this.plan = this.planManager.getPlanByKey(bcEvent.getPlanKey());
            BuildStatusHelper statusHelper = new BuildStatusHelper((ImmutablePlan)this.plan, this.plan.getPlanKey(), this.resultsSummary, this.resultsSummaryManager);
            this.firstFailedBuild = statusHelper.getFirstBuildInSequence();
            TriggerReason triggerReason = this.resultsSummary.getTriggerReason();
            TriggerReasonRenderer reasonRenderer = this.triggerManager.getTriggerReasonRenderer(triggerReason, this.resultsSummary);
            this.triggerReasonDescription = reasonRenderer.getLongDescriptionText();
            this.triggerReasonDescriptionHtml = reasonRenderer.getLongDescriptionHtml();
            if (this.firstFailedBuild != null) {
                TriggerReason firstTriggerReason = this.firstFailedBuild.getTriggerReason();
                TriggerReasonRenderer firstReasonRenderer = this.triggerManager.getTriggerReasonRenderer(firstTriggerReason, this.resultsSummary);
                this.firstFailedTriggerReasonDescription = firstReasonRenderer.getLongDescriptionText();
                this.firstFailedTriggerReasonDescriptionHtml = firstReasonRenderer.getLongDescriptionHtml();
            }
        } else {
            throw new IllegalArgumentException("Can not create Notification content with null event");
        }
    }

    @Nullable
    public String getTextEmailContent() throws Exception {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateMap(context);
            context.put("triggerReasonDescription", this.triggerReasonDescription);
            context.put("firstFailedTriggerReasonDescription", this.firstFailedTriggerReasonDescription);
            try {
                return this.templateRenderer.render(TEXT_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create text Email content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getHtmlEmailContent() throws Exception {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateMap(context);
            context.put("triggerReasonDescription", this.triggerReasonDescriptionHtml);
            context.put("firstFailedTriggerReasonDescription", this.firstFailedTriggerReasonDescriptionHtml);
            try {
                return this.templateRenderer.render(HTML_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Html Email content for " + this.getDescription()));
        return null;
    }

    private void populateMap(Map<String, Object> context) {
        context.put("notification", this);
        context.put("buildSummary", this.resultsSummary);
        context.put("build", this.plan);
        context.put("jiraIssues", Collections.emptyList());
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)Narrow.downTo((Object)this.resultsSummary, ChainResultsSummary.class);
        if (chainResultsSummary != null) {
            context.put("chainTestResults", ChainFilteredTestResults.newInstance(this.testsManager, this.testQuarantineManager, chainResultsSummary, 0, 25));
        }
        if (this.firstFailedBuild != null) {
            if (this.resultsSummary.getBuildState() == BuildState.FAILED) {
                context.put("numFailures", this.resultsSummary.getBuildNumber() - this.firstFailedBuild.getBuildNumber() + 1);
            } else {
                context.put("numFailures", this.resultsSummary.getBuildNumber() - this.firstFailedBuild.getBuildNumber());
            }
            context.put("firstFailedBuildSummary", this.firstFailedBuild);
        }
        context.put("branchStatus", this.branchStatusService.getBranchStatusLinkInfo(this.resultsSummary.getImmutablePlan(), "email"));
    }

    @Nullable
    public String getIMContent() {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateMap(context);
            context.put("triggerReasonDescription", this.triggerReasonDescription);
            context.put("firstFailedTriggerReasonDescription", this.firstFailedTriggerReasonDescription);
            try {
                return this.templateRenderer.render(IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Override
    @Nullable
    public String getHtmlImContent() {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateMap(context);
            context.put("triggerReasonDescription", this.triggerReasonDescription);
            context.put("firstFailedTriggerReasonDescription", this.firstFailedTriggerReasonDescription);
            try {
                return this.templateRenderer.render(HTML_IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    public String getEmailSubject() {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateMap(context);
            context.put("triggerReasonDescription", this.triggerReasonDescription);
            context.put("firstFailedTriggerReasonDescription", this.firstFailedTriggerReasonDescription);
            try {
                return this.templateRenderer.render(SUBJECT_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render IM content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Email subject for " + this.getDescription()));
        return null;
    }

    public String getCommitUrl(@NotNull RepositoryDataEntity repositoryDataEntity, String revision) {
        return this.getCommitUrl(repositoryDataEntity, revision, (ImmutablePlan)this.plan, this.customVariableContext, this.repositoryDefinitionManager, this.vcsRepositoryViewerManager);
    }
}

