/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.chain;

import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.notification.AbstractNotificationEventListener;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.chain.AfterXFailedNotification;
import com.atlassian.bamboo.notification.chain.AfterXFailedNotificationType;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.utils.BambooNotificationUtils;
import com.atlassian.event.Event;
import com.google.common.collect.Sets;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class AfterXFailedNotificationListener
extends AbstractNotificationEventListener<ChainCompletedEvent> {
    private static final Logger log = Logger.getLogger(AfterXFailedNotificationListener.class);
    private ResultsSummaryManager resultsSummaryManager;

    public AfterXFailedNotificationListener() {
        super(ChainCompletedEvent.class, Sets.newHashSet((Object[])new Class[]{AfterXFailedNotificationType.class}));
    }

    @Override
    public void handleEvent(@NotNull ChainCompletedEvent event, @NotNull ImmutablePlan plan) {
        AfterXFailedNotification xFailedNotification = BambooNotificationUtils.createNotification(AfterXFailedNotification.class);
        xFailedNotification.setEvent(event);
        xFailedNotification.init();
        for (NotificationRule rule : this.getNotificationRules(plan, event)) {
            log.debug((Object)("After X Failed Builds rule found for " + plan.getKey() + ", recipient: " + rule.getRecipient() + ", type: " + rule.getRecipientType()));
            NotificationRecipient recipient = this.notificationManager.getNotificationRecipient(rule);
            if (recipient instanceof NotificationRecipient.RequiresPlan) {
                ((NotificationRecipient.RequiresPlan)recipient).setPlan(plan);
            }
            if (recipient instanceof NotificationRecipient.RequiresResultSummary) {
                ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(event.getPlanResultKey());
                ((NotificationRecipient.RequiresResultSummary)recipient).setResultsSummary(resultsSummary);
            }
            if (recipient instanceof NotificationRecipient.RequiresEvent) {
                ((NotificationRecipient.RequiresEvent)recipient).setEvent((Event)event);
            }
            if (recipient == null) continue;
            xFailedNotification.addRecipient(recipient);
        }
        this.notificationDispatcher.dispatchNotifications((Notification)xFailedNotification);
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

