/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.chain;

import com.atlassian.bamboo.build.BuildStatusHelper;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.event.ChainResultEvent;
import com.atlassian.bamboo.notification.AbstractNotificationType;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AfterXFailedNotificationType
extends AbstractNotificationType {
    private static final Logger log = Logger.getLogger(AfterXFailedNotificationType.class);
    public static final int MINIMUM_FAILURES = 1;
    private int unacceptableNumberOfFailures = 1;
    private String numFailedString;
    private TemplateRenderer templateRenderer;
    private PlanManager planManager;
    private ResultsSummaryManager resultsSummaryManager;
    private static final String NUM_FAILED_FIELD = "numFailedTimes";

    @Override
    public void setConfigurationData(@Nullable String data) {
        if (data != null) {
            try {
                this.unacceptableNumberOfFailures = Integer.parseInt(data);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Unable to parse " + data), (Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public String getConfigurationData() {
        return String.valueOf(this.unacceptableNumberOfFailures);
    }

    @Override
    public boolean isNotificationRequired(@NotNull Object event) {
        if (event instanceof ChainResultEvent) {
            ChainResultEvent chainCompletedEvent = (ChainResultEvent)event;
            Plan plan = this.planManager.getPlanByKey(chainCompletedEvent.getPlanKey());
            ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(chainCompletedEvent.getPlanResultKey());
            if (plan != null && resultsSummary != null) {
                int lastSuccessNum;
                int failureCount;
                ResultsSummary lastSuccess;
                BuildStatusHelper statusHelper = new BuildStatusHelper((ImmutablePlan)plan, plan.getPlanKey(), resultsSummary, this.resultsSummaryManager);
                if (resultsSummary.isFailed()) {
                    int failureCount2 = statusHelper.getPrecedingConsecutiveFailuresCount() + 1;
                    if (failureCount2 >= this.unacceptableNumberOfFailures) {
                        log.debug((Object)(this.getNotificationName() + ": Build status is still " + resultsSummary.getBuildState() + " sending a notification "));
                        return true;
                    }
                } else if (resultsSummary.isSuccessful() && statusHelper.getFixesBuild() != null && (lastSuccess = statusHelper.getPreviousSuccessfulBuild()) != null && (failureCount = statusHelper.getCountOfPrecedingResultsInState(lastSuccessNum = lastSuccess.getBuildNumber(), BuildState.FAILED)) >= this.unacceptableNumberOfFailures) {
                    log.debug((Object)(this.getNotificationName() + ": Build status changed to " + resultsSummary.getBuildState() + " sending a notification "));
                    return true;
                }
            }
        }
        return false;
    }

    private String getNotificationName() {
        return "After X=" + this.unacceptableNumberOfFailures + " Failed Notification";
    }

    @Override
    public void populate(@NotNull Map<String, String[]> config) {
        this.unacceptableNumberOfFailures = Integer.parseInt(StringUtils.join((Object[])config.get(NUM_FAILED_FIELD)));
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull Map<String, String[]> params) {
        String numString;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        this.numFailedString = numString = StringUtils.join((Object[])params.get(NUM_FAILED_FIELD));
        try {
            int numTimes = Integer.parseInt(numString);
            if (numTimes < 1) {
                errorCollection.addError(NUM_FAILED_FIELD, "Please enter a number greater than 0");
            }
        }
        catch (NumberFormatException e) {
            errorCollection.addError(NUM_FAILED_FIELD, "Please enter a number");
        }
        return errorCollection;
    }

    @Override
    @NotNull
    public String getEditHtml() {
        String editTemplateLocation = this.notificationTypeModuleDescriptor.getEditTemplate();
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(NUM_FAILED_FIELD, StringUtils.defaultString((String)this.numFailedString, (String)String.valueOf(this.unacceptableNumberOfFailures)));
        return this.templateRenderer.render(editTemplateLocation, context);
    }

    @Override
    @NotNull
    public String getViewHtml() {
        return "Notify After " + this.unacceptableNumberOfFailures + " Consecutive Failures";
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

