/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.chain;

import com.atlassian.bamboo.notification.NotificationTypeExporter;
import com.atlassian.bamboo.specs.api.builders.notification.NotificationType;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.notification.NotificationTypeProperties;
import com.atlassian.bamboo.specs.builders.notification.XFailedChainsNotification;
import com.atlassian.bamboo.specs.model.notification.XFailedChainsNotificationProperties;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AfterXFailedNotificationTypeExporter
implements NotificationTypeExporter {
    @NotNull
    public NotificationType toSpecsEntity(@NotNull String conditionKey, @NotNull String conditionData) {
        Preconditions.checkArgument((boolean)XFailedChainsNotificationProperties.ATLASSIAN_PLUGIN.getCompleteModuleKey().equals(conditionKey), (Object)("Can't handle: " + conditionKey));
        try {
            int numberOfFailures = StringUtils.isBlank((CharSequence)conditionData) ? 1 : Integer.parseInt(conditionData);
            return new XFailedChainsNotification().numberOfFailures(numberOfFailures);
        }
        catch (NumberFormatException ex) {
            throw new PropertiesValidationException("Export failed. Can't parse " + conditionData, (Throwable)ex);
        }
    }

    @NotNull
    public String importNotificationType(NotificationTypeProperties condition) {
        XFailedChainsNotificationProperties properties = (XFailedChainsNotificationProperties)Narrow.downTo((Object)condition, XFailedChainsNotificationProperties.class);
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)("Can't handle: " + condition.getClass().getCanonicalName()));
        return String.valueOf(properties.getNumberOfFailures());
    }
}

