/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.chain;

import com.atlassian.bamboo.chains.ChainFilteredTestResults;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.chains.branches.BranchStatusService;
import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.notification.buildcompleted.AbstractCompletedNotification;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Inject;
import org.apache.log4j.Logger;

@NotThreadSafe
public class ChainCompletedNotification
extends AbstractCompletedNotification {
    private static final Logger log = Logger.getLogger(ChainCompletedNotification.class);
    private static final String TEXT_EMAIL_TEMPLATE = "notification-templates/ChainCompletedTextEmail.ftl";
    private static final String HTML_EMAIL_TEMPLATE = "notification-templates/ChainCompletedHtmlEmail.ftl";
    private static final String IM_TEMPLATE = "notification-templates/ChainCompletedIm.ftl";
    private static final String HTML_IM_TEMPLATE = "notification-templates/htmlIm/ChainCompletedHtmlIm.ftl";
    private static final String EMAIL_SUBJECT = "notification-templates/ChainCompletedEmailSubject.ftl";
    protected StageExecution stageExecution;
    protected int executedJobs = 0;
    private final TestsManager testsManager;
    private final TestQuarantineManager testQuarantineManager;

    @Inject
    public ChainCompletedNotification(BranchStatusService branchStatusService, CachedPlanManager cachedPlanManager, TestsManager testsManager, TestQuarantineManager testQuarantineManager, VcsRepositoryViewerManager vcsRepositoryViewerManager, RepositoryDefinitionManager repositoryDefinitionManager, CustomVariableContext customVariableContext) {
        super(branchStatusService, cachedPlanManager, vcsRepositoryViewerManager, repositoryDefinitionManager, customVariableContext);
        this.testsManager = testsManager;
        this.testQuarantineManager = testQuarantineManager;
    }

    @Override
    public void init() {
        super.init();
        Object event = this.getPojoEvent();
        ChainCompletedEvent chainCompletedEvent = (ChainCompletedEvent)event;
        List executedStages = chainCompletedEvent.getChainExecution().getStages();
        for (Object thisStage : executedStages) {
            this.stageExecution = (StageExecution)Narrow.to(thisStage, StageExecution.class);
            if (this.stageExecution == null) continue;
            this.executedJobs += this.stageExecution.getBuilds().size();
        }
    }

    @Override
    protected void populateContext(Map<String, Object> context) {
        super.populateContext(context);
        context.put("executedJobs", this.executedJobs);
        context.put("chainTestResults", ChainFilteredTestResults.newInstance(this.testsManager, this.testQuarantineManager, (ChainResultsSummary)this.resultsSummary, 0, 25));
    }

    @Override
    protected String getTextEmailTemplate() {
        return TEXT_EMAIL_TEMPLATE;
    }

    @Override
    protected String getHtmlEmailTemplate() {
        return HTML_EMAIL_TEMPLATE;
    }

    @Override
    protected String getImTemplate() {
        return IM_TEMPLATE;
    }

    @Override
    protected String getHtmlImTemplate() {
        return HTML_IM_TEMPLATE;
    }

    @Override
    protected String getEmailSubjectTemplate() {
        return EMAIL_SUBJECT;
    }
}

