/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.chain;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.event.HibernateEventListener;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationDispatcher;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationType;
import com.atlassian.bamboo.notification.chain.AllChainNotificationType;
import com.atlassian.bamboo.notification.chain.ChainCompletedNotification;
import com.atlassian.bamboo.notification.chain.ChainStatusChangeNotificationType;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.event.Event;
import com.atlassian.spring.container.ContainerManager;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;

@ThreadSafe
public class ChainCompletedNotificationListener
implements HibernateEventListener {
    private static final Logger log = Logger.getLogger(ChainCompletedNotificationListener.class);
    private NotificationManager notificationManager;
    private NotificationDispatcher notificationDispatcher;
    private PlanManager planManager;
    private ResultsSummaryManager resultsSummaryManager;

    public Class[] getHandledEventClasses() {
        return new Class[]{ChainCompletedEvent.class};
    }

    public void handleEvent(Event event) {
        if (!(event instanceof ChainCompletedEvent)) {
            return;
        }
        ChainCompletedEvent chainEvent = (ChainCompletedEvent)event;
        Chain chain = (Chain)this.planManager.getPlanByKey(chainEvent.getPlanKey(), Chain.class);
        log.debug((Object)("Completed Chain Notification Listener checking for notifications to send for " + chainEvent.getPlanResultKey()));
        Set rules = this.notificationManager.getNotificationRules((ImmutablePlan)chain);
        ChainCompletedNotification chainCompletedNotification = (ChainCompletedNotification)ContainerManager.getInstance().getContainerContext().createCompleteComponent(ChainCompletedNotification.class);
        chainCompletedNotification.setEvent(event);
        chainCompletedNotification.init();
        for (NotificationRule rule : rules) {
            NotificationType notificationType = this.notificationManager.getNotificationType(rule);
            if (!(notificationType instanceof AllChainNotificationType) && !(notificationType instanceof ChainStatusChangeNotificationType) || !notificationType.isNotificationRequired((Object)event)) continue;
            log.debug((Object)("Completed chain notification (class " + notificationType.getClass() + " ) rule found for recipient: " + rule.getRecipient() + ", type: " + rule.getRecipientType()));
            NotificationRecipient recipient = this.notificationManager.getNotificationRecipient(rule);
            if (recipient == null) continue;
            ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(chainEvent.getPlanResultKey());
            if (recipient instanceof NotificationRecipient.RequiresPlan) {
                ((NotificationRecipient.RequiresPlan)recipient).setPlan((ImmutablePlan)chain);
            }
            if (recipient instanceof NotificationRecipient.RequiresEvent) {
                ((NotificationRecipient.RequiresEvent)recipient).setEvent(event);
            }
            if (recipient instanceof NotificationRecipient.RequiresResultSummary) {
                ((NotificationRecipient.RequiresResultSummary)recipient).setResultsSummary(resultsSummary);
            }
            chainCompletedNotification.addRecipient(recipient);
        }
        this.notificationDispatcher.dispatchNotifications((Notification)chainCompletedNotification);
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setNotificationDispatcher(NotificationDispatcher notificationDispatcher) {
        this.notificationDispatcher = notificationDispatcher;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

