/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.chain;

import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.notification.AbstractNotificationType;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ChainStatusChangeNotificationType
extends AbstractNotificationType {
    private static final Logger log = Logger.getLogger(ChainStatusChangeNotificationType.class);
    private ResultsSummaryManager resultsSummaryManager;

    @Override
    public boolean isNotificationRequired(@NotNull Object event) {
        ChainCompletedEvent chainCompletedEvent = (ChainCompletedEvent)Narrow.to((Object)event, ChainCompletedEvent.class);
        if (chainCompletedEvent == null) {
            return false;
        }
        ChainExecution currentChainExecution = chainCompletedEvent.getChainExecution();
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.resultsSummaryManager.getResultsSummary(currentChainExecution.getPlanResultKey(), ChainResultsSummary.class);
        if (chainResultsSummary == null) {
            return false;
        }
        if (chainResultsSummary.isOnceOff()) {
            log.debug((Object)("Chain result type " + chainResultsSummary.getPlanResultKey() + " is ONCE_OFF, not sending ChainStatusChange notification."));
            return false;
        }
        ChainResultsSummary previousChainResult = (ChainResultsSummary)this.resultsSummaryManager.findLastResultBefore(chainCompletedEvent.getPlanResultKey(), ChainResultsSummary.class, false);
        if (previousChainResult != null) {
            boolean hasStatusChanged;
            boolean bl = hasStatusChanged = currentChainExecution.isSuccessful() != previousChainResult.isSuccessful();
            if (hasStatusChanged) {
                log.info((Object)("Plan status changed to " + (currentChainExecution.isSuccessful() ? "successful" : "failed") + " sending a notification "));
            } else if (!currentChainExecution.isSuccessful() && chainResultsSummary.getTestResultsSummary().getNewFailedTestCaseCount() > 0) {
                log.info((Object)"Plan failed but new failing tests sending a notification ");
                return true;
            }
            return hasStatusChanged;
        }
        return true;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }
}

