/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.chain;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.event.StageCompletedEvent;
import com.atlassian.bamboo.notification.AbstractNotification;
import com.atlassian.bamboo.notification.ExtendedNotification;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.mail.Email;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class StageCompletedNotification
extends AbstractNotification
implements ExtendedNotification {
    private static final Logger log = Logger.getLogger(StageCompletedNotification.class);
    public static final String TEXT_EMAIL_TEMPLATE = "notification-templates/StageCompletedTextEmail.ftl";
    public static final String HTML_EMAIL_TEMPLATE = "notification-templates/StageCompletedHtmlEmail.ftl";
    public static final String IM_TEMPLATE = "notification-templates/StageCompletedIm.ftl";
    public static final String HTML_IM_TEMPLATE = "notification-templates/htmlIm/StageCompletedHtmlIm.ftl";
    public static final String EMAIL_SUBJECT = "notification-templates/StageCompletedEmailSubject.ftl";
    private TemplateRenderer templateRenderer;
    private PlanManager planManager;
    protected ChainExecution chainExecution;
    protected StageExecution stageExecution;
    protected Chain chain;

    @NotNull
    public Email updateEmail(@NotNull Email email) {
        if (this.chain != null) {
            email.addHeader("X-Bamboo-Plan-Key", this.chain.getKey());
        }
        return email;
    }

    @NotNull
    public String getDescription() {
        return "Completed Stage Notification";
    }

    public void init() {
        Object event = this.getPojoEvent();
        if (event == null) {
            throw new IllegalArgumentException("Can not create Notification content with null event");
        }
        StageCompletedEvent stageCompletedEvent = (StageCompletedEvent)event;
        this.chainExecution = stageCompletedEvent.getChainExecution();
        this.stageExecution = stageCompletedEvent.getStageExecution();
        this.chain = (Chain)this.planManager.getPlanByKey(stageCompletedEvent.getPlanKey(), Chain.class);
    }

    @Nullable
    public String getTextEmailContent() throws Exception {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(TEXT_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Text Email content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getHtmlEmailContent() throws Exception {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(HTML_EMAIL_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Email content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getIMContent() {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render IM content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Override
    @Nullable
    public String getHtmlImContent() {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(HTML_IM_TEMPLATE, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render IM content", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create IM content for " + this.getDescription()));
        return null;
    }

    @Nullable
    public String getEmailSubject() {
        Object event = this.getPojoEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(EMAIL_SUBJECT, context);
            }
            catch (Exception e) {
                log.error((Object)"Could not render email subject", (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create email subject for " + this.getDescription()));
        return null;
    }

    protected void populateContext(Map<String, Object> context) {
        context.put("notification", this);
        context.put("chain", this.chain);
        context.put("chainExecution", this.chainExecution);
        context.put("stageState", this.stageExecution);
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }
}

