/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.chain;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.event.HibernateEventListener;
import com.atlassian.bamboo.event.StageCompletedEvent;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationDispatcher;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationType;
import com.atlassian.bamboo.notification.chain.AllStageNotificationType;
import com.atlassian.bamboo.notification.chain.StageCompletedNotification;
import com.atlassian.bamboo.notification.recipients.CommitterRecipient;
import com.atlassian.bamboo.notification.recipients.WatcherRecipient;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.event.Event;
import com.atlassian.spring.container.ContainerManager;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.log4j.Logger;

@ThreadSafe
public class StageCompletedNotificationListener
implements HibernateEventListener {
    private static final Logger log = Logger.getLogger(StageCompletedNotificationListener.class);
    private NotificationManager notificationManager;
    private NotificationDispatcher notificationDispatcher;
    private PlanManager planManager;

    public Class[] getHandledEventClasses() {
        Class[] array = new Class[]{StageCompletedEvent.class};
        return array;
    }

    public void handleEvent(Event event) {
        if (!(event instanceof StageCompletedEvent)) {
            return;
        }
        StageCompletedEvent stageCompletedEvent = (StageCompletedEvent)event;
        Chain chain = (Chain)this.planManager.getPlanByKey(stageCompletedEvent.getPlanKey(), Chain.class);
        log.debug((Object)("Completed Stage Notification Listener checking for notifications to send for " + stageCompletedEvent.getPlanResultKey()));
        Set rules = this.notificationManager.getNotificationRules((ImmutablePlan)chain);
        StageCompletedNotification stageCompletedNotification = (StageCompletedNotification)ContainerManager.getInstance().getContainerContext().createCompleteComponent(StageCompletedNotification.class);
        stageCompletedNotification.setEvent(event);
        stageCompletedNotification.init();
        for (NotificationRule rule : rules) {
            NotificationType notificationType = this.notificationManager.getNotificationType(rule);
            if (!(notificationType instanceof AllStageNotificationType) || !notificationType.isNotificationRequired((Object)event)) continue;
            log.debug((Object)("Completed stage notification (class " + notificationType.getClass() + " ) rule found for recipient: " + rule.getRecipient() + ", type: " + rule.getRecipientType()));
            NotificationRecipient recipient = this.notificationManager.getNotificationRecipient(rule);
            if (recipient instanceof WatcherRecipient) {
                WatcherRecipient watcher = (WatcherRecipient)recipient;
                watcher.setPlan((ImmutablePlan)chain);
                stageCompletedNotification.addRecipient(watcher);
                continue;
            }
            if (recipient instanceof CommitterRecipient) continue;
            stageCompletedNotification.addRecipient(recipient);
        }
        this.notificationDispatcher.dispatchNotifications((Notification)stageCompletedNotification);
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setNotificationDispatcher(NotificationDispatcher notificationDispatcher) {
        this.notificationDispatcher = notificationDispatcher;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }
}

