/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.recipients;

import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.notification.recipients.UserRecipient;
import com.atlassian.bamboo.plugin.descriptor.NotificationRecipientModuleDescriptor;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.plugin.web.descriptors.WeightedDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNotificationRecipient
implements NotificationRecipient {
    protected NotificationRecipientModuleDescriptor notificationRecipientModuleDescriptor;

    public void init(@NotNull WeightedDescriptor moduleDescriptor) {
        Preconditions.checkArgument((boolean)(moduleDescriptor instanceof NotificationRecipientModuleDescriptor), (String)"Descriptor not of type %s", (Object[])new Object[]{NotificationRecipientModuleDescriptor.class.getCanonicalName()});
        this.notificationRecipientModuleDescriptor = (NotificationRecipientModuleDescriptor)moduleDescriptor;
    }

    @Nullable
    public WeightedDescriptor getModuleDescriptor() {
        return this.notificationRecipientModuleDescriptor;
    }

    @NotNull
    public String getDescription() {
        return this.notificationRecipientModuleDescriptor.getDescription();
    }

    @NotNull
    public String getKey() {
        return this.notificationRecipientModuleDescriptor.getCompleteKey();
    }

    public void init(@Nullable String configurationData) {
    }

    @NotNull
    public String getRecipientConfig() {
        return "";
    }

    public void populate(@NotNull Map<String, String[]> params) {
    }

    @NotNull
    public ErrorCollection validate(@NotNull Map<String, String[]> params) {
        return new SimpleErrorCollection();
    }

    @NotNull
    public String getEditHtml() {
        return "";
    }

    @NotNull
    public String getViewHtml() {
        return "";
    }

    protected String getParam(String key, Map<String, String[]> params) {
        StringBuilder paramString = new StringBuilder();
        Arrays.stream((Object[])params.get(key)).filter(Objects::nonNull).forEach(paramString::append);
        return paramString.toString().trim();
    }

    public int compareTo(Object o) {
        NotificationRecipient recipient = (NotificationRecipient)o;
        if (recipient.getModuleDescriptor() != null && this.getModuleDescriptor() != null) {
            WeightedDescriptorComparator comparator = new WeightedDescriptorComparator();
            return comparator.compare(this.getModuleDescriptor(), recipient.getModuleDescriptor());
        }
        return this.getKey().compareTo(recipient.getKey());
    }

    protected List<NotificationTransport> getTransports(Set<UserRecipient> userRecipients) {
        ArrayList<NotificationTransport> transports = new ArrayList<NotificationTransport>();
        for (UserRecipient recipient : userRecipients) {
            transports.addAll(recipient.getTransports());
        }
        return transports;
    }
}

