/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.recipients;

import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitManager;
import com.atlassian.bamboo.notification.NotificationFactory;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.notification.recipients.AbstractNotificationRecipient;
import com.atlassian.bamboo.notification.recipients.UserRecipient;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitterRecipient
extends AbstractNotificationRecipient
implements NotificationRecipient.RequiresResultSummary,
NotificationRecipient.UserRecipientExpandable,
NotificationRecipient.RequiresPlan {
    private static final Logger log = Logger.getLogger(CommitterRecipient.class);
    private Set<? extends CommitContext> commits = Collections.emptySet();
    private NotificationFactory notificationFactory;
    private BambooPermissionManager permissionManager;
    private CommitManager commitManager;
    private ImmutablePlan plan;

    @NotNull
    public List<NotificationTransport> getTransports() {
        return this.getTransports(this.getUserRecipients());
    }

    @NotNull
    public Set<UserRecipient> getUserRecipients() {
        HashSet<UserRecipient> recipients = new HashSet<UserRecipient>();
        if (this.commits == null || this.commits.isEmpty()) {
            log.debug((Object)"No commits found. Not sending any notifications");
        } else {
            for (CommitContext commitContext : this.commits) {
                if (commitContext.isForeignCommit()) {
                    log.debug((Object)("Commit " + commitContext.getChangeSetId() + " comes from another branch. Skipping"));
                    continue;
                }
                AuthorContext author = commitContext.getAuthorContext();
                if (author != null) {
                    String userName = author.getLinkedUserName();
                    if (StringUtils.isNotBlank((CharSequence)userName)) {
                        if (this.permissionManager.hasPermission(userName, (Permission)BambooPermission.READ, (Object)this.plan)) {
                            log.debug((Object)("Committer Recipient Found. Author: " + author.getName() + ", User: " + userName));
                            recipients.add(this.notificationFactory.getUserRecipient(userName));
                            continue;
                        }
                        log.debug((Object)("Commiter " + userName + " is skipped because doesn't have VIEW permission to plan " + this.plan.getPlanKey()));
                        continue;
                    }
                    log.debug((Object)("Author " + author.getName() + " does not have a linked user. Skipping"));
                    continue;
                }
                log.debug((Object)"No author found for commit. Skipping");
            }
        }
        return recipients;
    }

    @Override
    @NotNull
    public String getViewHtml() {
        return "Committers <span class='notificationRecipientType'> (users who have committed to the build) </span>";
    }

    public void setResultsSummary(@Nullable ResultsSummary resultsSummary) {
        if (resultsSummary != null) {
            this.setCommits(this.commitManager.getCommitsForResult(resultsSummary));
            log.debug((Object)(this.commits.size() + " commits found to send notifications for."));
        } else {
            log.debug((Object)"No committer notifications will be sent: no result summary was found");
        }
    }

    public void setNotificationFactory(NotificationFactory notificationFactory) {
        this.notificationFactory = notificationFactory;
    }

    public void setCommits(Set<? extends CommitContext> commits) {
        this.commits = commits;
    }

    public void setPlan(@Nullable ImmutablePlan plan) {
        this.plan = plan;
    }

    public void setPermissionManager(BambooPermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setCommitManager(CommitManager commitManager) {
        this.commitManager = commitManager;
    }
}

