/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.recipients;

import com.atlassian.bamboo.notification.EmailValidator;
import com.atlassian.bamboo.notification.NotificationFactory;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.notification.recipients.AbstractNotificationRecipient;
import com.atlassian.bamboo.notification.transports.MultipartEmailTransport;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmailRecipient
extends AbstractNotificationRecipient {
    private static final Logger log = Logger.getLogger(EmailRecipient.class);
    public static final String EMAIL_FIELD = "notificationEmailString";
    private String emailAddress;
    private NotificationFactory notificationFactory;
    private TemplateRenderer templateRenderer;

    @NotNull
    public List<NotificationTransport> getTransports() {
        ArrayList<NotificationTransport> transportList = new ArrayList<NotificationTransport>();
        if (StringUtils.isNotBlank((CharSequence)this.emailAddress)) {
            log.debug((Object)("Email Recipient Found: " + this.emailAddress));
            MultipartEmailTransport emailTransport = this.notificationFactory.getMultipartEmailTransport(this.emailAddress);
            transportList.add(emailTransport);
        }
        return transportList;
    }

    @Override
    public void init(@Nullable String configurationData) {
        this.emailAddress = configurationData;
    }

    @Override
    @NotNull
    public String getRecipientConfig() {
        return this.emailAddress;
    }

    @Override
    public void populate(@NotNull Map<String, String[]> params) {
        this.emailAddress = this.getParam(EMAIL_FIELD, params);
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull Map<String, String[]> params) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String[] emailArray = params.get(EMAIL_FIELD);
        if (emailArray == null || emailArray.length == 0) {
            errorCollection.addError(EMAIL_FIELD, "Please enter an email address");
            return errorCollection;
        }
        this.emailAddress = this.getParam(EMAIL_FIELD, params);
        if (StringUtils.isBlank((CharSequence)this.emailAddress)) {
            errorCollection.addError(EMAIL_FIELD, "Please enter an email address");
            return errorCollection;
        }
        if (!EmailValidator.isValidEmailAddressFormat(this.emailAddress)) {
            errorCollection.addError(EMAIL_FIELD, "Email address \"" + this.emailAddress + "\" is not in a valid format");
        }
        return errorCollection;
    }

    @Override
    @NotNull
    public String getEditHtml() {
        String editTemplateLocation = this.notificationRecipientModuleDescriptor.getEditTemplate();
        HashMap<String, String> context = new HashMap<String, String>();
        if (this.emailAddress != null) {
            context.put(EMAIL_FIELD, this.emailAddress);
        }
        return this.templateRenderer.render(editTemplateLocation, context);
    }

    @Override
    @NotNull
    public String getViewHtml() {
        return StringEscapeUtils.escapeHtml4((String)this.emailAddress) + "<span class='notificationRecipientType'> (email address)</span>";
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setNotificationFactory(NotificationFactory notificationFactory) {
        this.notificationFactory = notificationFactory;
    }
}

