/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.recipients;

import com.atlassian.bamboo.notification.NotificationFactory;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.notification.recipients.AbstractNotificationRecipient;
import com.atlassian.bamboo.notification.recipients.UserRecipient;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.user.Group;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupRecipient
extends AbstractNotificationRecipient
implements NotificationRecipient.UserRecipientExpandable {
    private static final Logger log = Logger.getLogger(GroupRecipient.class);
    public static final String GROUP_FIELD = "notificationGroupString";
    private String groupName;
    private BambooUserManager bambooUserManager;
    private TemplateRenderer templateRenderer;
    private NotificationFactory notificationFactory;

    @NotNull
    public List<NotificationTransport> getTransports() {
        return this.getTransports(this.getUserRecipients());
    }

    @NotNull
    public Set<UserRecipient> getUserRecipients() {
        HashSet<UserRecipient> recipientList = new HashSet<UserRecipient>();
        Group group = this.bambooUserManager.getGroup(this.groupName);
        if (group != null) {
            for (String name : this.bambooUserManager.getMemberNamesAsList(group)) {
                recipientList.add(this.notificationFactory.getUserRecipient(name));
            }
        } else {
            log.debug((Object)("Notifications for group " + this.groupName + " could not be sent, no group with this name could be found"));
        }
        return recipientList;
    }

    @Override
    public void init(@Nullable String configurationData) {
        this.groupName = configurationData;
    }

    @Override
    @NotNull
    public String getRecipientConfig() {
        return this.groupName;
    }

    @Override
    public void populate(@NotNull Map<String, String[]> params) {
        this.groupName = this.getParam(GROUP_FIELD, params);
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull Map<String, String[]> params) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String[] groupArray = params.get(GROUP_FIELD);
        if (groupArray == null || groupArray.length == 0) {
            errorCollection.addError(GROUP_FIELD, "Please enter a group name");
            return errorCollection;
        }
        this.groupName = this.getParam(GROUP_FIELD, params);
        if (StringUtils.isBlank((CharSequence)this.groupName)) {
            errorCollection.addError(GROUP_FIELD, "Please enter a group name");
            return errorCollection;
        }
        try {
            Group group = this.bambooUserManager.getGroup(this.groupName);
            if (group == null) {
                errorCollection.addError(GROUP_FIELD, "Group \"" + this.groupName + "\" does not exist");
            }
        }
        catch (Exception e) {
            errorCollection.addError(GROUP_FIELD, "Group \"" + this.groupName + "\" does not exist");
        }
        return errorCollection;
    }

    @Override
    @NotNull
    public String getEditHtml() {
        String parsedResult;
        String editTemplateLocation = this.notificationRecipientModuleDescriptor.getEditTemplate();
        HashMap<String, String> context = new HashMap<String, String>();
        if (this.groupName != null) {
            context.put(GROUP_FIELD, this.groupName);
        }
        return (parsedResult = this.templateRenderer.render(editTemplateLocation, context)) != null ? parsedResult : "";
    }

    @Override
    @NotNull
    public String getViewHtml() {
        return StringEscapeUtils.escapeHtml4((String)this.groupName) + "<span class='notificationRecipientType'> (group)</span>";
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setNotificationFactory(NotificationFactory notificationFactory) {
        this.notificationFactory = notificationFactory;
    }
}

