/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.recipients;

import com.atlassian.bamboo.notification.NotificationRecipientExporter;
import com.atlassian.bamboo.specs.api.builders.notification.NotificationRecipient;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.builders.notification.GroupRecipient;
import com.atlassian.bamboo.specs.model.notification.GroupRecipientProperties;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.user.Group;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class GroupRecipientExporter
implements NotificationRecipientExporter {
    @Inject
    private BambooUserManager bambooUserManager;

    @NotNull
    public NotificationRecipient toSpecsEntity(@NotNull String recipientKey, @NotNull String recipientData) {
        return new GroupRecipient(recipientData);
    }

    @NotNull
    public String importNotificationRecipient(NotificationRecipientProperties recipient) {
        GroupRecipientProperties groupRecipient = (GroupRecipientProperties)Narrow.downTo((Object)recipient, GroupRecipientProperties.class);
        if (groupRecipient != null) {
            String groupName = groupRecipient.getGroupName();
            Group group = this.bambooUserManager.getGroup(groupName);
            if (group == null) {
                throw new PropertiesValidationException(String.format("Group \"%s\" does not exist", groupName));
            }
            return groupName;
        }
        throw new IllegalStateException("Don't know how to import notification type class: " + recipient.getClass().getName());
    }
}

