/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.recipients;

import com.atlassian.bamboo.notification.NotificationFactory;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.notification.recipients.AbstractNotificationRecipient;
import com.atlassian.bamboo.notification.transports.ImTransport;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImRecipient
extends AbstractNotificationRecipient {
    private static final Logger log = Logger.getLogger(ImRecipient.class);
    public static final String IM_FIELD = "notificationIMString";
    private String imAddress;
    private NotificationFactory notificationFactory;
    private TemplateRenderer templateRenderer;

    @NotNull
    public List<NotificationTransport> getTransports() {
        ArrayList<NotificationTransport> transportList = new ArrayList<NotificationTransport>();
        if (StringUtils.isNotBlank((CharSequence)this.imAddress)) {
            log.debug((Object)("IM Recipient Found: " + this.imAddress));
            ImTransport transport = this.notificationFactory.getImTransport(this.imAddress);
            transportList.add(transport);
        }
        return transportList;
    }

    @Override
    public void init(@Nullable String configurationData) {
        this.imAddress = configurationData;
    }

    @Override
    @NotNull
    public String getRecipientConfig() {
        return this.imAddress;
    }

    @Override
    public void populate(@NotNull Map<String, String[]> params) {
        this.imAddress = this.getParam(IM_FIELD, params);
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull Map<String, String[]> params) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String[] imArray = params.get(IM_FIELD);
        if (imArray == null || imArray.length == 0) {
            errorCollection.addError(IM_FIELD, "Please enter an instant messaging address");
            return errorCollection;
        }
        this.imAddress = this.getParam(IM_FIELD, params);
        if (StringUtils.isBlank((CharSequence)this.imAddress)) {
            errorCollection.addError(IM_FIELD, "Please enter an instant messaging address");
            return errorCollection;
        }
        return errorCollection;
    }

    @Override
    @NotNull
    public String getEditHtml() {
        String editTemplateLocation = this.notificationRecipientModuleDescriptor.getEditTemplate();
        HashMap<String, String> context = new HashMap<String, String>();
        if (this.imAddress != null) {
            context.put(IM_FIELD, this.imAddress);
        }
        String parsedResult = this.templateRenderer.render(editTemplateLocation, context);
        return parsedResult;
    }

    @Override
    @NotNull
    public String getViewHtml() {
        return StringEscapeUtils.escapeHtml4((String)this.imAddress) + "<span class='notificationRecipientType'> (im address)</span>";
    }

    public void setImAddress(String imAddress) {
        this.imAddress = imAddress;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setNotificationFactory(NotificationFactory notificationFactory) {
        this.notificationFactory = notificationFactory;
    }
}

