/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.recipients;

import com.atlassian.bamboo.notification.NotificationRecipientExporter;
import com.atlassian.bamboo.specs.api.builders.notification.NotificationRecipient;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.builders.notification.UserRecipient;
import com.atlassian.bamboo.specs.model.notification.UserRecipientProperties;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.Narrow;
import com.opensymphony.xwork2.TextProvider;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class UserRecipientExporter
implements NotificationRecipientExporter {
    @Inject
    private BambooUserManager bambooUserManager;
    @Inject
    private TextProvider textProvider;

    @NotNull
    public NotificationRecipient toSpecsEntity(@NotNull String recipientKey, @NotNull String recipientData) {
        return new UserRecipient(recipientData);
    }

    @NotNull
    public String importNotificationRecipient(NotificationRecipientProperties recipient) {
        UserRecipientProperties userRecipient = (UserRecipientProperties)Narrow.downTo((Object)recipient, UserRecipientProperties.class);
        if (userRecipient != null) {
            String username = userRecipient.getUserName();
            BambooUser user = this.bambooUserManager.getBambooUser(username);
            if (user == null) {
                throw new PropertiesValidationException(this.textProvider.getText("notification.recipients.users.notexist", new String[]{username}));
            }
            return username;
        }
        throw new IllegalStateException("Don't know how to import notification type class: " + recipient.getClass().getName());
    }
}

