/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.recipients;

import com.atlassian.bamboo.notification.NotificationFactory;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.notification.recipients.AbstractNotificationRecipient;
import com.atlassian.bamboo.notification.recipients.UserRecipient;
import com.atlassian.bamboo.notification.transports.AbstractEmailTransport;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.opensymphony.xwork2.TextProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserRecipientImpl
extends AbstractNotificationRecipient
implements UserRecipient {
    private static final Logger log = Logger.getLogger(UserRecipient.class);
    private String username;
    private BambooUserManager bambooUserManager;
    private NotificationFactory notificationFactory;
    private TemplateRenderer templateRenderer;
    private TextProvider textProvider;

    @NotNull
    public List<NotificationTransport> getTransports() {
        ArrayList<NotificationTransport> transportList = new ArrayList<NotificationTransport>();
        BambooUser user = this.bambooUserManager.getBambooUser(this.username);
        if (user != null) {
            log.debug((Object)("Found User To Notify: " + this.username));
            if (!user.isEnabled()) {
                log.debug((Object)("User " + this.username + " is disabled. Skipping"));
                return transportList;
            }
            String userPreference = user.getNotificationPreference();
            if ("none".equals(userPreference)) {
                log.debug((Object)("User " + this.username + " has selected to not receive any notifications. Skipping"));
            } else if ("im".equals(userPreference)) {
                String imAddress = user.getJabberAddress();
                if (StringUtils.isNotBlank((CharSequence)imAddress)) {
                    log.debug((Object)("User " + this.username + " has selected to receive IM notifications only."));
                    transportList.add(this.notificationFactory.getImTransport(imAddress));
                } else {
                    log.debug((Object)("User " + user.getName() + " has selected to recieve IM notification but does not have a jabber address"));
                }
            } else if ("textEmail".equals(userPreference)) {
                String emailAddress = user.getEmail();
                if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
                    log.debug((Object)("User " + this.username + " has selected to receive Email notifications only."));
                    transportList.add(this.getEmailNotificationTransport(user, emailAddress));
                } else {
                    log.debug((Object)("User " + user.getName() + " has selected to recieve email notifications but does not have an email address"));
                }
            } else {
                String emailAddress = user.getEmail();
                log.debug((Object)("User " + this.username + " has selected to receive both email and im notifications."));
                if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
                    transportList.add(this.getEmailNotificationTransport(user, emailAddress));
                } else {
                    log.debug((Object)("User " + user.getName() + " does not have an email address specified"));
                }
                String imAddress = user.getJabberAddress();
                if (StringUtils.isNotBlank((CharSequence)imAddress)) {
                    transportList.add(this.notificationFactory.getImTransport(imAddress));
                } else {
                    log.debug((Object)("User " + user.getName() + " does not have an IM address specified"));
                }
            }
        } else {
            log.debug((Object)("Could not send Notification for User Recipient. User " + this.username + " could not be found"));
        }
        return transportList;
    }

    @Override
    public void init(@Nullable String configurationData) {
        this.username = configurationData;
    }

    @Override
    @NotNull
    public String getRecipientConfig() {
        return this.username;
    }

    @Override
    public void populate(@NotNull Map<String, String[]> params) {
        this.username = this.getParam("notificationUserString", params);
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull Map<String, String[]> params) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String[] userArray = params.get("notificationUserString");
        if (userArray == null || userArray.length == 0) {
            errorCollection.addError("notificationUserString", this.textProvider.getText("notification.recipients.users.notspecified"));
            return errorCollection;
        }
        this.username = this.getParam("notificationUserString", params);
        if (StringUtils.isBlank((CharSequence)this.username)) {
            errorCollection.addError("notificationUserString", this.textProvider.getText("notification.recipients.users.notspecified"));
            return errorCollection;
        }
        BambooUser user = this.bambooUserManager.getBambooUser(this.username);
        if (user == null) {
            errorCollection.addError("notificationUserString", this.textProvider.getText("notification.recipients.users.notexist", new String[]{this.username}));
        }
        return errorCollection;
    }

    @Override
    @NotNull
    public String getEditHtml() {
        String editTemplateLocation = this.notificationRecipientModuleDescriptor.getEditTemplate();
        HashMap<String, String> context = new HashMap<String, String>();
        if (this.username != null) {
            context.put("notificationUserString", this.username);
        }
        return StringUtils.defaultString((String)this.templateRenderer.render(editTemplateLocation, context));
    }

    @Override
    @NotNull
    public String getViewHtml() {
        BambooUser user;
        String viewTemplateLocation = this.notificationRecipientModuleDescriptor.getViewTemplate();
        HashMap<String, CharSequence> context = new HashMap<String, CharSequence>();
        if (this.username != null) {
            context.put("notificationUserString", this.username);
        }
        if ((user = this.bambooUserManager.getBambooUser(this.username)) != null) {
            context.put("notificationUserFullNameString", StringUtils.defaultIfBlank((CharSequence)user.getFullName(), (CharSequence)user.getName()));
        }
        return StringUtils.defaultString((String)this.templateRenderer.render(viewTemplateLocation, context));
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    public void setNotificationFactory(NotificationFactory notificationFactory) {
        this.notificationFactory = notificationFactory;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    private NotificationTransport getEmailNotificationTransport(BambooUser user, String emailAddress) {
        String userTransportPreference = user.getNotificationTransportPreference();
        AbstractEmailTransport emailTransport = "text".equals(userTransportPreference) ? this.notificationFactory.getTextEmailTransport(emailAddress) : this.notificationFactory.getMultipartEmailTransport(emailAddress);
        return emailTransport;
    }

    public String toString() {
        return "UserRecipientImpl{username='" + this.username + '\'' + '}';
    }
}

