/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.recipients;

import com.atlassian.bamboo.labels.LabelManager;
import com.atlassian.bamboo.notification.NotificationFactory;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.notification.recipients.AbstractNotificationRecipient;
import com.atlassian.bamboo.notification.recipients.UserRecipient;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.Narrow;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatcherRecipient
extends AbstractNotificationRecipient
implements NotificationRecipient.RequiresPlan,
NotificationRecipient.UserRecipientExpandable {
    private static final Logger log = Logger.getLogger(WatcherRecipient.class);
    private LabelManager labelManager;
    private ImmutablePlan plan;
    private NotificationFactory notificationFactory;
    private BambooPermissionManager permissionManager;

    @NotNull
    public List<NotificationTransport> getTransports() {
        return this.getTransports(this.getUserRecipients());
    }

    @NotNull
    public Set<UserRecipient> getUserRecipients() {
        HashSet<UserRecipient> recipientList = new HashSet<UserRecipient>();
        if (this.plan == null) {
            log.debug((Object)"Watcher notification recipient found but plan was null. Could not send notifications");
            return recipientList;
        }
        ImmutableJob job = (ImmutableJob)Narrow.to((Object)this.plan, ImmutableJob.class);
        List favouriters = job != null ? this.labelManager.getFavouritesForPlan((ImmutablePlan)job.getParent()) : this.labelManager.getFavouritesForPlan(this.plan);
        if (favouriters != null) {
            for (String userName : favouriters) {
                if (StringUtils.isBlank((CharSequence)userName)) continue;
                if (this.permissionManager.hasPermission(userName, (Permission)BambooPermission.READ, (Object)this.plan)) {
                    recipientList.add(this.notificationFactory.getUserRecipient(userName));
                    log.debug((Object)("Found watcher to notify: " + userName));
                    continue;
                }
                log.debug((Object)("Skip notification for " + userName + " who doesn't have VIEW permission for plan " + this.plan.getPlanKey()));
            }
        } else {
            log.debug((Object)"No people are watching the plan/job.  Skipping");
        }
        return recipientList;
    }

    @Override
    @NotNull
    public String getViewHtml() {
        return "Watchers <span class='notificationRecipientType'> (users who have marked this build as their favourite)</span>";
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setPlan(@Nullable ImmutablePlan plan) {
        this.plan = plan;
    }

    public void setNotificationFactory(NotificationFactory notificationFactory) {
        this.notificationFactory = notificationFactory;
    }

    public void setPermissionManager(BambooPermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

