/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.rss;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.specs.api.model.plan.PlanProperties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RssAffectedPlan {
    private final String name;
    private final PlanKey planKey;
    private final String projectName;
    private final String projectKey;
    private final Set<String> projectsMissingRssAccess;
    private final Set<String> repositoriesMissingRssAccess;
    private boolean disabled;
    private Integer buildNumber;

    public RssAffectedPlan(@NotNull PlanProperties topLevelPlanProperties) {
        this(topLevelPlanProperties, null, null);
    }

    public RssAffectedPlan(String projectName, PlanKey planKey, String planName, boolean disabled) {
        this.name = planName;
        this.planKey = planKey;
        this.projectName = projectName;
        this.projectKey = PlanKeys.getProjectKeyPart((PlanKey)planKey);
        this.projectsMissingRssAccess = null;
        this.repositoriesMissingRssAccess = null;
        this.disabled = disabled;
    }

    public RssAffectedPlan(@NotNull PlanProperties topLevelPlanProperties, @Nullable Set<String> projectsMissingRssAccess, @Nullable Set<String> repositoriesMissingRssAccess) {
        this.name = topLevelPlanProperties.getName();
        this.planKey = PlanKeys.getPlanKey((String)topLevelPlanProperties.getProject().getKey().getKey(), (String)topLevelPlanProperties.getKey().getKey());
        this.projectName = topLevelPlanProperties.getProject().getName();
        this.projectKey = topLevelPlanProperties.getProject().getKey().getKey();
        this.projectsMissingRssAccess = projectsMissingRssAccess;
        this.repositoriesMissingRssAccess = repositoriesMissingRssAccess;
        this.disabled = !topLevelPlanProperties.isEnabled();
    }

    public RssAffectedPlan(@NotNull ImmutablePlan plan, @Nullable Integer buildNumber) {
        this.planKey = plan.getPlanKey();
        this.name = plan.getBuildName();
        this.projectKey = plan.getProject().getKey();
        this.projectName = plan.getProject().getName();
        this.projectsMissingRssAccess = null;
        this.repositoriesMissingRssAccess = null;
        this.disabled = plan.isSuspendedFromBuilding();
        this.buildNumber = buildNumber;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    @NotNull
    public String getProjectName() {
        return this.projectName;
    }

    @NotNull
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nullable
    public Set<String> getProjectsMissingRssAccess() {
        return this.projectsMissingRssAccess;
    }

    @Nullable
    public Set<String> getRepositoriesMissingRssAccess() {
        return this.repositoriesMissingRssAccess;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Nullable
    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(@Nullable Integer buildNumber) {
        this.buildNumber = buildNumber;
    }

    public boolean isRssMissingAnyAccess() {
        return this.projectsMissingRssAccess != null && !this.projectsMissingRssAccess.isEmpty() || this.repositoriesMissingRssAccess != null && !this.repositoriesMissingRssAccess.isEmpty();
    }
}

