/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.rss;

import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.event.rss.RssErrorEvent;
import com.atlassian.bamboo.event.rss.RssEvent;
import com.atlassian.bamboo.event.rss.RssSuccessfulEvent;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationDispatcher;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.notification.buildcompleted.BuildCompletedNotificationListener;
import com.atlassian.bamboo.notification.rss.RssNotification;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.BambooNotificationUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.VcsCommitCommenter;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RssEventListener {
    private static final Logger log = Logger.getLogger(BuildCompletedNotificationListener.class);
    private static final String EMAIL_RECIPIENT_PLUGIN_KEY = "com.atlassian.bamboo.plugin.system.notifications:recipient.email";
    @Inject
    private NotificationDispatcher notificationDispatcher;
    @Inject
    private NotificationManager notificationManager;
    @Inject
    private VcsRepositoryManager vcsRepositoryManager;
    @Inject
    private BambooUserManager userManager;

    @EventListener
    public void onRssError(@NotNull RssErrorEvent event) {
        this.sendNotifications(event);
    }

    @EventListener
    public void onRssSuccessful(@NotNull RssSuccessfulEvent event) {
        this.sendNotifications(event);
    }

    private void sendNotifications(@NotNull RssEvent event) {
        try {
            this.sendEmailNotifications(event);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.sendCommitLevelNotifications(event);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void sendCommitLevelNotifications(@NotNull RssEvent event) {
        if (SystemProperty.RSS_COMMIT_LEVEL_COMMENT_DISABLED.getTypedValue()) {
            log.debug((Object)"Commit level comment feature is disabled. Skipping...");
            return;
        }
        VcsRepositoryModuleDescriptor repositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(event.getRepositoryData().getPluginKey());
        if (repositoryModuleDescriptor == null) {
            log.info((Object)("Can't find repository plugin by key: " + event.getRepositoryData().getPluginKey() + ". Skipping commit level comment"));
            return;
        }
        if (!repositoryModuleDescriptor.supportsCommitComment()) {
            log.debug((Object)("Plugin " + event.getRepositoryData().getPluginKey() + " doesn't support commit level comment. Skipping notification"));
            return;
        }
        event.getCommits().forEach(commit -> this.sendCommitComment(repositoryModuleDescriptor.getVcsCommitCommenter(), event, (CommitContext)commit));
    }

    private void sendCommitComment(final VcsCommitCommenter commitCommenter, final RssEvent event, final CommitContext commit) {
        BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<Void>("Can't publish commit"){

            @Override
            @Nullable
            public Void call() {
                try {
                    String changeSetId = commit.getChangeSetId();
                    if (changeSetId == null) {
                        log.info((Object)("Can't send commit comment as commit is null for " + (Object)((Object)event)));
                    } else {
                        commitCommenter.publishRssStatus(event.getRepositoryData(), changeSetId, (Event)event);
                    }
                }
                catch (RepositoryException e) {
                    log.error((Object)e.getMessage());
                }
                return null;
            }
        });
    }

    private void sendEmailNotifications(@NotNull RssEvent event) {
        RssNotification rspNotification = BambooNotificationUtils.createNotification(RssNotification.class);
        rspNotification.setEvent(event);
        log.debug((Object)("Rss notification listener checking for notifications to send for " + event.getRepositoryData().getName()));
        for (NotificationRecipient recipient : this.createRecipients(event)) {
            rspNotification.addRecipient(recipient);
        }
        this.notificationDispatcher.dispatchNotifications((Notification)rspNotification);
    }

    private List<NotificationRecipient> createRecipients(@NotNull RssEvent event) {
        return event.getCommits().stream().map(this::getCommitAuthorEmail).filter(Objects::nonNull).map(email -> {
            NotificationRecipient emailRecipient = this.notificationManager.getNotificationRecipientFromKey(EMAIL_RECIPIENT_PLUGIN_KEY);
            emailRecipient.init(email);
            return emailRecipient;
        }).collect(Collectors.toList());
    }

    @Nullable
    private String getCommitAuthorEmail(@NotNull CommitContext c) {
        AuthorContext authorContext = c.getAuthorContext();
        String email = authorContext.getEmail();
        if (StringUtils.isNotBlank((CharSequence)email)) {
            return email;
        }
        return this.getLinkedUserEmail(authorContext.getLinkedUserName());
    }

    @Nullable
    private String getLinkedUserEmail(String linkedUserName) {
        BambooUser user;
        if (StringUtils.isNotBlank((CharSequence)linkedUserName) && (user = this.userManager.getBambooUser(linkedUserName)) != null) {
            return user.getEmail();
        }
        return null;
    }
}

