/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.rss;

import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.configuration.external.RepositoryStoredSpecsLogService;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.event.analytics.RssLogDownloadEvent;
import com.atlassian.bamboo.event.rss.RssErrorEvent;
import com.atlassian.bamboo.event.rss.RssEvent;
import com.atlassian.bamboo.event.rss.RssSuccessfulEvent;
import com.atlassian.bamboo.notification.AbstractNotification;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.DescriptionProvider;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RssNotification
extends AbstractNotification {
    private static final Logger log = Logger.getLogger(RssNotification.class);
    public static final String SPEC_TEXT_ERROR_EMAIL_TEMPLATE = "notification-templates/BuildSpecErrorTextEmail.ftl";
    public static final String SPEC_HTML_ERROR_EMAIL_TEMPLATE = "notification-templates/BuildSpecErrorHtmlEmail.ftl";
    public static final String SPEC_TEXT_SUCCESS_EMAIL_TEMPLATE = "notification-templates/BuildSpecSuccessTextEmail.ftl";
    public static final String SPEC_HTML_SUCCESS_EMAIL_TEMPLATE = "notification-templates/BuildSpecSuccessHtmlEmail.ftl";
    private TemplateRenderer templateRenderer;
    @Inject
    private VcsRepositoryViewerManager vcsRepositoryViewerManager;
    @Inject
    private ProjectManager projectManager;
    @Inject
    private DeploymentProjectService deploymentProjectService;
    @Inject
    private RepositoryStoredSpecsLogService repositoryStoredSpecsLogService;
    @Inject
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Inject
    private CustomVariableContext customVariableContext;
    @Inject
    private VariableSubstitutorFactory variableSubstitutorFactory;

    @NotNull
    public String getDescription() {
        return "Repository stored plan error notification";
    }

    @Nullable
    public String getTextEmailContent() throws Exception {
        RssEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(this.getTextEmailTemplate(event), context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render text email content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create Text Email content for " + this.getDescription()));
        return null;
    }

    @NotNull
    private String getTextEmailTemplate(RssEvent event) {
        if (event instanceof RssErrorEvent) {
            return SPEC_TEXT_ERROR_EMAIL_TEMPLATE;
        }
        if (event instanceof RssSuccessfulEvent) {
            return SPEC_TEXT_SUCCESS_EMAIL_TEMPLATE;
        }
        throw new IllegalStateException("Unknown event type " + ((Object)((Object)event)).getClass().getCanonicalName());
    }

    @Nullable
    public String getHtmlEmailContent() {
        RssEvent event = this.getEvent();
        if (event != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            this.populateContext(context);
            try {
                return this.templateRenderer.render(this.getHtmlEmailTemplate(event), context);
            }
            catch (Exception e) {
                log.error((Object)("Could not render HTML email content for " + this.getDescription()), (Throwable)e);
                return null;
            }
        }
        log.error((Object)("Event is null, could not create HTML Email content for " + this.getDescription()));
        return null;
    }

    @NotNull
    private String getHtmlEmailTemplate(RssEvent event) {
        if (event instanceof RssErrorEvent) {
            return SPEC_HTML_ERROR_EMAIL_TEMPLATE;
        }
        if (event instanceof RssSuccessfulEvent) {
            return SPEC_HTML_SUCCESS_EMAIL_TEMPLATE;
        }
        throw new IllegalStateException("Unknown event type " + ((Object)((Object)event)).getClass().getCanonicalName());
    }

    @Nullable
    public String getEmailSubject() {
        RssEvent event = this.getEvent();
        if (event instanceof RssErrorEvent) {
            return "Updating Bamboo Specs from repository " + event.getRepositoryData().getName() + " failed";
        }
        if (event instanceof RssSuccessfulEvent) {
            return "Updating Bamboo Specs from repository " + event.getRepositoryData().getName() + " has been successful";
        }
        return null;
    }

    @Nullable
    public String getIMContent() {
        throw new UnsupportedOperationException("Rss notification for IM not supported yet");
    }

    @Override
    @Nullable
    public String getHtmlImContent() {
        throw new UnsupportedOperationException("Rss notification for IM not supported yet");
    }

    @Override
    @Nullable
    public RssEvent getEvent() {
        return (RssEvent)((Object)Narrow.downTo((Object)this.getPojoEvent(), RssEvent.class));
    }

    protected void populateContext(@NotNull Map<String, Object> context) {
        context.put("notification", this);
        VcsRepositoryData repositoryData = this.getEvent().getRepositoryData();
        List commits = (List)this.customVariableContext.withVariableSubstitutor(this.variableSubstitutorFactory.newSubstitutorForGlobalContext(), () -> {
            VcsRepositoryViewer vcsRepositoryViewer = this.vcsRepositoryViewerManager.getViewerForRepository(repositoryData);
            return this.getEvent().getCommits().stream().map(c -> new CommitWithUrl((CommitContext)c, vcsRepositoryViewer != null ? vcsRepositoryViewer.getWebRepositoryUrlForRevision(c.getChangeSetId(), repositoryData) : null)).collect(Collectors.toList());
        });
        context.put("commits", commits);
        if (!commits.isEmpty()) {
            context.put("changeSetUrl", this.repositoryStoredSpecsLogService.generateSpecsLogsUrl(repositoryData.getRootVcsRepositoryId(), commits, RssLogDownloadEvent.Referrer.EMAIL.getName()));
        }
        List affectedDeployments = this.getEvent().getAffectedDeploymentProjects().stream().map(id -> this.deploymentProjectService.getDeploymentProject(id.longValue())).filter(Objects::nonNull).map(RssAffectedDeployment::new).collect(Collectors.toList());
        context.put("affectedBuilds", this.getEvent().getAffectedPlans());
        context.put("affectedDeployments", affectedDeployments);
        this.addProjectsMissingRssAccess(context);
        this.addRepositoriesMissingRssAccess(context);
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    private void addProjectsMissingRssAccess(@NotNull Map<String, Object> context) {
        if (this.getEvent() instanceof RssErrorEvent) {
            Map<String, String> projectNames = this.getEvent().getAffectedPlans().stream().filter(plan -> plan.getProjectsMissingRssAccess() != null).flatMap(plan -> plan.getProjectsMissingRssAccess().stream()).distinct().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectByKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toMap(ProjectIdentifier::getKey, ProjectIdentifier::getName));
            this.getEvent().getAffectedPlans().stream().filter(plan -> plan.getBuildNumber() == null).filter(plan -> !projectNames.containsKey(plan.getProjectKey())).forEach(plan -> projectNames.put(plan.getProjectKey(), plan.getProjectName()));
            context.put("projectsNames", projectNames);
        }
    }

    private void addRepositoriesMissingRssAccess(@NotNull Map<String, Object> context) {
        if (this.getEvent() instanceof RssErrorEvent) {
            Map<String, Long> repositoriesIds = this.getEvent().getAffectedPlans().stream().filter(plan -> plan.getRepositoriesMissingRssAccess() != null).flatMap(plan -> plan.getRepositoriesMissingRssAccess().stream()).distinct().map(arg_0 -> ((RepositoryDefinitionManager)this.repositoryDefinitionManager).getLinkedRepositoryByName(arg_0)).filter(Objects::nonNull).collect(Collectors.toMap(DescriptionProvider::getName, BambooIdProvider::getId));
            context.put("repositoriesIds", repositoriesIds);
        }
    }

    public static class CommitWithUrl
    implements CommitContext {
        private final CommitContext source;
        private final String url;

        public CommitWithUrl(@NotNull CommitContext commitContext, @Nullable String url) {
            this.source = commitContext;
            this.url = StringUtils.defaultString((String)url);
        }

        public AuthorContext getAuthorContext() {
            return this.source.getAuthorContext();
        }

        @NotNull
        public List<CommitFile> getFiles() {
            return this.source.getFiles();
        }

        @NotNull
        public String getComment() {
            return this.source.getComment();
        }

        @NotNull
        public Date getDate() {
            return this.source.getDate();
        }

        @Nullable
        public String getChangeSetId() {
            return this.source.getChangeSetId();
        }

        @Nullable
        public String guessChangeSetId() {
            return this.source.guessChangeSetId();
        }

        public boolean isForeignCommit() {
            return this.source.isForeignCommit();
        }

        @NotNull
        public String getUrl() {
            return this.url;
        }
    }

    public static class RssAffectedDeployment {
        private final String name;
        private final long id;

        public RssAffectedDeployment(DeploymentProject deploymentProject) {
            this.name = deploymentProject.getName();
            this.id = deploymentProject.getId();
        }

        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }
    }
}

