/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.transports;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.event.EmailEvent;
import com.atlassian.bamboo.notification.ExtendedNotification;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.Email;
import org.jetbrains.annotations.NotNull;

abstract class AbstractEmailTransport
implements NotificationTransport {
    private final String emailAddress;
    private final EventPublisher eventPublisher;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public AbstractEmailTransport(String emailAddress, EventPublisher eventPublisher, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.eventPublisher = eventPublisher;
        this.emailAddress = emailAddress;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    protected Email beginEmail(@NotNull Notification notification) throws Exception {
        Email email = new Email(this.emailAddress);
        email.setSubject(notification.getEmailSubject());
        email.addHeader("X-Bamboo-Notification-Type", notification.getClass().getName());
        email.addHeader("X-Bamboo-Server-URL", this.getBaseUrl());
        return email;
    }

    protected Email updateEmail(@NotNull Email email, @NotNull Notification notification) {
        if (notification instanceof ExtendedNotification) {
            ExtendedNotification extendedNotification = (ExtendedNotification)notification;
            email = extendedNotification.updateEmail(email);
        }
        return email;
    }

    protected void send(Email email) {
        this.eventPublisher.publish((Object)new EmailEvent(this, email));
    }

    private String getBaseUrl() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().getBaseUrl();
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }
}

