/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.transports;

import com.atlassian.bamboo.event.BuildResultEvent;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationTransport;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.xmpp.BambooSmackClient;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jivesoftware.smack.packet.Message;

@ThreadSafe
public class ImTransport
implements NotificationTransport {
    private static final Logger log = Logger.getLogger(ImTransport.class);
    private final String imAddress;
    private final BambooSmackClient bambooSmackClient;
    private final PlanManager planManager;

    public ImTransport(String imAddress, BambooSmackClient bambooSmackClient, PlanManager planManager) {
        this.bambooSmackClient = bambooSmackClient;
        this.imAddress = imAddress;
        this.planManager = planManager;
    }

    public void sendNotification(@NotNull Notification notification) {
        String recipient = this.getImAddress();
        if (recipient == null) {
            log.error((Object)("Empty recipient for " + notification.getDescription() + " could not send notification"));
        } else {
            Object event = notification.getPojoEvent();
            String message = notification.getIMContent();
            if (StringUtils.isNotBlank((CharSequence)message)) {
                if (event instanceof BuildResultEvent) {
                    BuildResultEvent brEvent = (BuildResultEvent)event;
                    PlanResultKey planResultKey = brEvent.getPlanResultKey();
                    Plan plan = this.planManager.getPlanByKey(brEvent.getPlanKey());
                    HashMap<String, String> notificationContext = new HashMap<String, String>();
                    notificationContext.put("project.key", plan.getProject().getKey());
                    notificationContext.put("build.key", plan.getBuildKey());
                    notificationContext.put("build.number", Integer.toString(planResultKey.getBuildNumber()));
                    notificationContext.put("server.response", "NOTIFICATION_BUILD_SUCCESS");
                    notificationContext.put("created", new Date().toString());
                    notificationContext.put("updated", new Date().toString());
                    this.bambooSmackClient.putUserMessageContext(recipient, notificationContext);
                }
                Message responseMessage = new Message(recipient, Message.Type.chat);
                responseMessage.setBody(message);
                this.bambooSmackClient.send(responseMessage);
            } else {
                log.error((Object)("Im content for " + notification.getDescription() + " was empty, could not send notification"));
            }
        }
    }

    public String getImAddress() {
        return this.imAddress;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 171).append((Object)this.getImAddress()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImTransport)) {
            return false;
        }
        ImTransport rhs = (ImTransport)o;
        return new EqualsBuilder().append((Object)this.getImAddress(), (Object)rhs.getImAddress()).isEquals();
    }

    public int compareTo(Object obj) {
        ImTransport o = (ImTransport)obj;
        return new CompareToBuilder().append((Object)this.getImAddress(), (Object)o.getImAddress()).toComparison();
    }
}

