/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.transports;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationFormatter;
import com.atlassian.bamboo.notification.transports.AbstractEmailTransport;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.Email;
import javax.annotation.concurrent.ThreadSafe;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class MultipartEmailTransport
extends AbstractEmailTransport {
    private static final Logger log = Logger.getLogger(MultipartEmailTransport.class);
    private final NotificationFormatter notificationFormatter;

    public MultipartEmailTransport(String emailAddress, EventPublisher eventPublisher, NotificationFormatter notificationFormatter, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        super(emailAddress, eventPublisher, administrationConfigurationAccessor);
        this.notificationFormatter = notificationFormatter;
    }

    public void sendNotification(@NotNull Notification notification) {
        block16: {
            try {
                String htmlContent;
                if (this.getEmailAddress() == null) {
                    log.error((Object)("Empty recipient for " + notification.getDescription() + " could not send notification"));
                    break block16;
                }
                Email email = this.beginEmail(notification);
                MimeMultipart mp = new MimeMultipart("alternative");
                String textContent = notification.getTextEmailContent();
                if (StringUtils.isNotBlank((CharSequence)textContent)) {
                    MimeBodyPart textPart = new MimeBodyPart();
                    textPart.setText(textContent);
                    mp.addBodyPart((BodyPart)textPart);
                }
                if (StringUtils.isNotBlank((CharSequence)(htmlContent = notification.getHtmlEmailContent()))) {
                    if (notification.applyDefaultCssStyles()) {
                        try {
                            htmlContent = this.notificationFormatter.applyStyles(htmlContent);
                        }
                        catch (Exception e) {
                            log.warn((Object)("Failed to apply notification formatting: " + e.getMessage()), (Throwable)e);
                        }
                    }
                    MimeBodyPart htmlPart = new MimeBodyPart();
                    htmlPart.setContent((Object)htmlContent, "text/html; charset=UTF-8");
                    mp.addBodyPart((BodyPart)htmlPart);
                }
                email.setMultipart((Multipart)mp);
                email = this.updateEmail(email, notification);
                if (StringUtils.isBlank((CharSequence)email.getSubject())) {
                    log.error((Object)(notification.getDescription() + " multipart email subject was empty, could not send notification"));
                } else if (StringUtils.isBlank((CharSequence)email.getTo())) {
                    log.error((Object)(notification.getDescription() + " multipart email recipient was empty, could not send notification"));
                } else if (email.getMultipart() != null && email.getMultipart().getCount() > 0) {
                    this.send(email);
                } else if (StringUtils.isNotBlank((CharSequence)email.getBody())) {
                    this.send(email);
                } else {
                    log.error((Object)(notification.getDescription() + " multipart email contents were empty, did not send notification"));
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to send out " + notification.getDescription() + " multipart email"), (Throwable)e);
            }
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 171).append((Object)this.getEmailAddress()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultipartEmailTransport)) {
            return false;
        }
        MultipartEmailTransport rhs = (MultipartEmailTransport)o;
        return new EqualsBuilder().append((Object)this.getEmailAddress(), (Object)rhs.getEmailAddress()).isEquals();
    }
}

