/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification.transports;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.transports.AbstractEmailTransport;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mail.Email;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public class TextEmailTransport
extends AbstractEmailTransport {
    private static final Logger log = Logger.getLogger(TextEmailTransport.class);

    public TextEmailTransport(String emailAddress, EventPublisher eventPublisher, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        super(emailAddress, eventPublisher, administrationConfigurationAccessor);
    }

    public void sendNotification(@NotNull Notification notification) {
        try {
            if (this.getEmailAddress() == null) {
                log.error((Object)("Empty recipient for " + notification.getDescription() + " could not send notification"));
            } else {
                Email email = this.beginEmail(notification);
                email.setMimeType("text/plain");
                email.setBody(notification.getTextEmailContent());
                email = this.updateEmail(email, notification);
                if (StringUtils.isBlank((CharSequence)email.getBody())) {
                    log.error((Object)(notification.getDescription() + " text email content was empty, could not send notification"));
                } else if (StringUtils.isBlank((CharSequence)email.getSubject())) {
                    log.error((Object)(notification.getDescription() + " text email subject was empty, could not send notification"));
                } else if (StringUtils.isBlank((CharSequence)email.getTo())) {
                    log.error((Object)(notification.getDescription() + " text email recipient was empty, could not send notification"));
                } else {
                    this.send(email);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to send out " + notification.getDescription() + " text email"), (Throwable)e);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 171).append((Object)this.getEmailAddress()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextEmailTransport)) {
            return false;
        }
        TextEmailTransport rhs = (TextEmailTransport)o;
        return new EqualsBuilder().append((Object)this.getEmailAddress(), (Object)rhs.getEmailAddress()).isEquals();
    }

    public int compareTo(Object obj) {
        TextEmailTransport o = (TextEmailTransport)obj;
        return new CompareToBuilder().append((Object)this.getEmailAddress(), (Object)o.getEmailAddress()).toComparison();
    }
}

