/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.osgi;

import com.atlassian.bamboo.util.Resettable;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Supplier;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.FactoryBean;

public class ReloadableBeanFactoryImpl
implements Resettable,
FactoryBean {
    private static final Logger log = Logger.getLogger(ReloadableBeanFactoryImpl.class);
    protected final ResettableLazyReference<Object> bean;
    protected volatile FactoryBean factoryBean;
    protected final ResettableLazyReference<Object> proxyReference = new ResettableLazyReference<Object>(){

        protected Object create() throws Exception {
            return Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), ReloadableBeanFactoryImpl.this.getInterfaces(), new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return method.invoke(ReloadableBeanFactoryImpl.this.bean.get(), args);
                }
            });
        }
    };

    ReloadableBeanFactoryImpl(FactoryBean factoryBean) {
        this(() -> factoryBean);
    }

    public ReloadableBeanFactoryImpl(Class<?> cls, Object ... args) {
        this(ReloadableBeanFactoryImpl.createFactoryBeanSupplierFromClass(cls, args));
    }

    private ReloadableBeanFactoryImpl(final Supplier<FactoryBean> factoryBeanSupplier) {
        this.bean = new ResettableLazyReference<Object>(){

            protected Object create() throws Exception {
                ReloadableBeanFactoryImpl.this.refreshFactoryBean(factoryBeanSupplier);
                return ReloadableBeanFactoryImpl.this.factoryBean.getObject();
            }
        };
        this.refreshFactoryBean(factoryBeanSupplier);
        this.proxyReference.reset();
    }

    private static Supplier<FactoryBean> createFactoryBeanSupplierFromClass(final Class<?> cls, final Object ... args) {
        return new Supplier<FactoryBean>(){

            @Override
            public FactoryBean get() {
                try {
                    return (FactoryBean)ConstructorUtils.invokeConstructor((Class)((Class)Preconditions.checkNotNull((Object)cls)), (Object[])args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Object getObject() throws Exception {
        return this.proxyReference.get();
    }

    public Class getObjectType() {
        return this.factoryBean.getObjectType();
    }

    public boolean isSingleton() {
        return this.factoryBean.isSingleton();
    }

    public void reset() {
        log.debug((Object)"Resetting OSGi reference");
        this.bean.reset();
        this.proxyReference.reset();
    }

    private void refreshFactoryBean(Supplier<FactoryBean> factoryBeanSupplier) {
        this.factoryBean = factoryBeanSupplier.get();
        Preconditions.checkArgument((boolean)this.factoryBean.isSingleton());
    }

    private Class<?>[] getInterfaces() {
        return new Class[]{this.factoryBean.getObjectType()};
    }
}

