/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.performance;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.performance.ActionIdentifier;
import com.atlassian.bamboo.performance.PerformanceStatsEvent;
import com.atlassian.bamboo.performance.PerformanceStatsService;
import com.atlassian.bamboo.utils.statistics.Stats;
import com.atlassian.event.api.EventPublisher;
import java.time.LocalDate;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class PerformanceStatsDispatchJob
implements Job {
    private static final Logger log = Logger.getLogger(PerformanceStatsDispatchJob.class);
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private PerformanceStatsService performanceStatsService;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        LocalDate now = LocalDate.now();
        Map statistics = this.performanceStatsService.getAndClearStatistics();
        if (this.featureManager.isPerformanceDataGatheringEnabled()) {
            log.info((Object)String.format("Sending performance statistics for %d actions", statistics.size()));
            statistics.entrySet().stream().map(entry -> new PerformanceStatsEvent((ActionIdentifier)entry.getKey(), now, (Stats)entry.getValue())).peek(this::logEvent).forEach(arg_0 -> ((EventPublisher)this.eventPublisher).publish(arg_0));
        } else {
            log.info((Object)"Not sending performance statistics - feature disabled");
        }
    }

    private void logEvent(@NotNull PerformanceStatsEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Sending performance stats for %s action %s", event.getActionType(), event.getActionName()));
        }
    }
}

