/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.performance;

import com.atlassian.bamboo.performance.PerformanceStatsDispatchJob;
import com.atlassian.bamboo.schedule.BambooScheduler;
import com.atlassian.bamboo.utils.SystemProperty;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class PerformanceStatsDispatchScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(PerformanceStatsDispatchScheduler.class);
    private static final String NAME_PREFIX = "PerformanceStatsDispatch";
    private static final String GROUP_NAME = "PerformanceStatsDispatchGroup";
    private static final String JOB_TRIGGER_NAME = "PerformanceStatsDispatchTrigger";
    private static final String JOB_NAME = "PerformanceStatsDispatchJob";
    private static final JobKey JOB_KEY = new JobKey("PerformanceStatsDispatchJob", "PerformanceStatsDispatchGroup");
    private static final TriggerKey TRIGGER_KEY = new TriggerKey("PerformanceStatsDispatchTrigger", "PerformanceStatsDispatchGroup");
    private final Scheduler scheduler;

    @Inject
    public PerformanceStatsDispatchScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void initialiseSchedule() {
        try {
            int sendHour = (int)Math.floorMod(SystemProperty.PERFORMANCE_DATA_DISPATCH_HOUR.getTypedValue(), 24L);
            log.info((Object)String.format("Scheduling sending analytics with performance data at %d:00", sendHour));
            JobDetail jobDetail = JobBuilder.newJob(PerformanceStatsDispatchJob.class).withIdentity(JOB_KEY).build();
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(TRIGGER_KEY).withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)sendHour, (int)0)).forJob(JOB_KEY).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (NumberFormatException | SchedulerException e) {
            log.error((Object)String.format("Unable to schedule %s", JOB_NAME), e);
        }
    }
}

