/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.performance;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bamboo.performance.ActionIdentifier;
import com.atlassian.bamboo.utils.statistics.Stats;
import com.atlassian.bamboo.vcs.AnalyticsUtils;
import com.atlassian.event.api.AsynchronousPreferred;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@AsynchronousPreferred
@EventName(value="bamboo.performance.stats")
public class PerformanceStatsEvent {
    private final String actionType;
    private final String actionName;
    private final String date;
    private final long invocations;
    private final double timeAvg;
    private final double timeMin;
    private final double timeMax;
    private final double timeStdDev;
    private final Map<String, Double> percentiles;

    public PerformanceStatsEvent(@NotNull ActionIdentifier actionIdentifier, @NotNull LocalDate date, @NotNull Stats stats) {
        this.actionType = actionIdentifier.getType().name();
        this.actionName = AnalyticsUtils.anonymizeFreeText(actionIdentifier.getName());
        this.date = DateTimeFormatter.ISO_LOCAL_DATE.format(date);
        this.invocations = stats.getCount();
        this.timeAvg = stats.getAverage();
        this.timeMin = stats.getMin();
        this.timeMax = stats.getMax();
        this.timeStdDev = stats.getStdDeviation();
        this.percentiles = stats.getPercentiles().entrySet().stream().collect(Collectors.toMap(p -> String.valueOf(p.getKey()), Map.Entry::getValue));
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getDate() {
        return this.date;
    }

    public long getInvocations() {
        return this.invocations;
    }

    public double getTimeAvg() {
        return this.timeAvg;
    }

    public double getTimeMin() {
        return this.timeMin;
    }

    public double getTimeMax() {
        return this.timeMax;
    }

    public double getTimeStdDev() {
        return this.timeStdDev;
    }

    public Map<String, Double> getPercentiles() {
        return this.percentiles;
    }
}

