/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.performance;

import com.atlassian.bamboo.performance.ActionIdentifier;
import com.atlassian.bamboo.performance.PerformanceStatsService;
import com.atlassian.bamboo.performance.StatsAccumulatorImpl;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.statistics.Stats;
import com.atlassian.bamboo.utils.statistics.StatsAccumulator;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PerformanceStatsServiceImpl
implements PerformanceStatsService {
    private static final Logger log = Logger.getLogger(PerformanceStatsServiceImpl.class);
    private static final long ONE_YEAR_DURATION_IN_MS = Duration.ofDays(365L).toMillis();
    private final ManagedLock.ReadWrite serviceLock = ManagedLocks.manageReadWrite((ReadWriteLock)new ReentrantReadWriteLock());
    private volatile Map<ActionIdentifier, StatsAccumulator> statsAccumulators = new ConcurrentHashMap<ActionIdentifier, StatsAccumulator>();

    public void recordExecution(@NotNull ActionIdentifier actionIdentifier, long durationMillis) {
        Preconditions.checkArgument((durationMillis >= 0L ? 1 : 0) != 0, (Object)"Duration cannot be negative");
        if (durationMillis > ONE_YEAR_DURATION_IN_MS) {
            log.warn((Object)("Problem in measurement of call duration " + actionIdentifier + ", measured duration [ms]: " + durationMillis));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Logging " + actionIdentifier + ", time taken " + Duration.ofMillis(durationMillis) + ", time taken [ms] " + durationMillis));
        }
        this.serviceLock.read().withLock(() -> {
            StatsAccumulator statsAccumulator;
            StatsAccumulator statsAccumulator2 = statsAccumulator = this.statsAccumulators.computeIfAbsent(actionIdentifier, id -> new StatsAccumulatorImpl());
            synchronized (statsAccumulator2) {
                statsAccumulator.add((double)durationMillis);
            }
        });
    }

    @NotNull
    public Map<ActionIdentifier, Stats> getAndClearStatistics() {
        Map currentStatsAccumulators = (Map)this.serviceLock.write().withLock(() -> {
            Map<ActionIdentifier, StatsAccumulator> current = this.statsAccumulators;
            this.statsAccumulators = new ConcurrentHashMap<ActionIdentifier, StatsAccumulator>();
            return current;
        });
        return currentStatsAccumulators.entrySet().stream().map(entry -> Pair.make(entry.getKey(), (Object)((StatsAccumulator)entry.getValue()).getStats())).filter(stats -> stats.getSecond() != null).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }
}

