/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.performance;

import com.atlassian.bamboo.performance.StatsImpl;
import com.atlassian.bamboo.utils.statistics.Stats;
import com.atlassian.bamboo.utils.statistics.StatsAccumulator;
import com.google.common.base.Preconditions;
import com.tdunning.math.stats.TDigest;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.log4j.Logger;

@NotThreadSafe
public class StatsAccumulatorImpl
implements StatsAccumulator {
    private static final Logger log = Logger.getLogger(StatsAccumulator.class);
    private final TDigest tDigest = TDigest.createMergingDigest((double)100.0);
    private double sum = 0.0;
    private double sumOfSquares = 0.0;
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;

    public void add(double value) {
        Preconditions.checkArgument((boolean)Double.isFinite(value), (Object)"Can't calculate statistics for infinite values or NaNs");
        this.min = Math.min(this.min, value);
        this.max = Math.max(this.max, value);
        this.sum += value;
        this.sumOfSquares += value * value;
        this.tDigest.add(value);
    }

    @Nullable
    public Stats getStats() {
        if (this.tDigest.size() == 0L) {
            log.debug((Object)"Returning null, since no statistics have been collected.");
            return null;
        }
        long count = this.tDigest.size();
        double stdDev = Math.sqrt(this.sumOfSquares / (double)count - Math.pow(this.sum / (double)count, 2.0));
        Map<Integer, Double> percentiles = PERCENTILES.stream().collect(Collectors.toMap(Function.identity(), p -> this.tDigest.quantile((double)p.intValue() / 100.0)));
        return StatsImpl.builder().count(count).min(this.min).max(this.max).average(this.sum / (double)count).stdDeviation(stdDev).percentiles(percentiles).build();
    }
}

