/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.performance;

import com.atlassian.bamboo.utils.statistics.Stats;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Immutable
public final class StatsImpl
implements Stats {
    private final long count;
    private final double min;
    private final double max;
    private final double average;
    private final double stdDeviation;
    private final Map<Integer, Double> percentiles;

    private StatsImpl(Builder builder) {
        this.count = builder.count;
        this.min = builder.min;
        this.max = builder.max;
        this.average = builder.average;
        this.stdDeviation = builder.stdDeviation;
        this.percentiles = Collections.unmodifiableMap(builder.percentiles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatsImpl)) {
            return false;
        }
        StatsImpl stats = (StatsImpl)o;
        return this.count == stats.count && Double.compare(stats.min, this.min) == 0 && Double.compare(stats.max, this.max) == 0 && Double.compare(stats.average, this.average) == 0 && Double.compare(stats.stdDeviation, this.stdDeviation) == 0 && Objects.equals(this.percentiles, stats.percentiles);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.min, this.max, this.average, this.stdDeviation, this.percentiles);
    }

    public String toString() {
        ToStringBuilder percentilesStringBuilder = new ToStringBuilder(this.percentiles, ToStringStyle.NO_CLASS_NAME_STYLE);
        this.percentiles.forEach((p, v) -> percentilesStringBuilder.append(String.valueOf(p), v));
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("count", this.count).append("min", this.min).append("max", this.max).append("average", this.average).append("std deviation", this.stdDeviation).append("percentiles", (Object)percentilesStringBuilder.toString()).toString();
    }

    public long getCount() {
        return this.count;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getAverage() {
        return this.average;
    }

    public double getStdDeviation() {
        return this.stdDeviation;
    }

    public Map<Integer, Double> getPercentiles() {
        return this.percentiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long count;
        private double min;
        private double max;
        private double average;
        private double stdDeviation;
        private Map<Integer, Double> percentiles;

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder min(double min) {
            this.min = min;
            return this;
        }

        public Builder max(double max) {
            this.max = max;
            return this;
        }

        public Builder average(double average) {
            this.average = average;
            return this;
        }

        public Builder stdDeviation(double stdDeviation) {
            this.stdDeviation = stdDeviation;
            return this;
        }

        public Builder percentiles(Map<Integer, Double> percentiles) {
            this.percentiles = percentiles.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return this;
        }

        public StatsImpl build() {
            return new StatsImpl(this);
        }
    }
}

