/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class BambooSessionFactoryUtils {
    private static final Logger log = Logger.getLogger(BambooSessionFactoryUtils.class);

    public static Session getNewSession(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        try {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
            if (sessionHolder == null) {
                return sessionFactory.openSession();
            }
            Session exisitingSession = sessionHolder.getSession();
            if (exisitingSession == null) {
                return sessionFactory.openSession();
            }
            Connection connection = BambooSessionFactoryUtils.getConnection(exisitingSession);
            Session session = sessionFactory.withOptions().connection(connection).openSession();
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)ex);
        }
    }

    @NotNull
    public static Connection getConnection(Session session) {
        return (Connection)session.doReturningWork(c -> c);
    }

    public static void applyTransactionTimeout(Query query, SessionFactory sessionFactory) {
        Preconditions.checkArgument((query != null ? 1 : 0) != 0, (Object)"No Query object specified");
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (sessionHolder != null && sessionHolder.hasTimeout()) {
            query.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static void applyTransactionTimeout(Criteria criteria, SessionFactory sessionFactory) {
        Preconditions.checkArgument((criteria != null ? 1 : 0) != 0, (Object)"No Criteria object specified");
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (sessionHolder != null && sessionHolder.hasTimeout()) {
            criteria.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }
}

