/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence;

import com.atlassian.config.db.HibernateConfig;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.orm.hibernate5.support.OpenSessionInViewFilter;

public class BambooSessionInViewFilter
extends OpenSessionInViewFilter {
    private static final Logger log = Logger.getLogger(BambooSessionInViewFilter.class);
    private static final ThreadLocal<Boolean> inSessionInView = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (ContainerManager.isContainerSetup() && this.isDatabaseSetUp()) {
            inSessionInView.set(true);
            try {
                super.doFilterInternal(request, response, filterChain);
            }
            finally {
                inSessionInView.remove();
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static boolean isInSessionInView() {
        return Boolean.TRUE.equals(inSessionInView.get());
    }

    @VisibleForTesting
    public static void markAsSessionInView(boolean value) {
        inSessionInView.set(value);
    }

    protected boolean isDatabaseSetUp() {
        HibernateConfig hibernateConfig;
        try {
            hibernateConfig = (HibernateConfig)ContainerManager.getComponent((String)"hibernateConfig");
        }
        catch (Exception e) {
            log.error((Object)"Unable to find bean in spring context");
            return false;
        }
        return hibernateConfig.isHibernateSetup();
    }
}

