/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence;

import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import org.hibernate.Hibernate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HibernateLazyReferences {
    private HibernateLazyReferences() {
    }

    public static void initialise(@Nullable ElasticImageConfiguration elasticImageConfiguration) {
        if (elasticImageConfiguration != null) {
            Hibernate.initialize((Object)elasticImageConfiguration.getStartupScripts());
        }
    }

    public static void initialise(@Nullable ElasticInstanceSchedule elasticInstanceSchedule) {
        if (elasticInstanceSchedule != null) {
            HibernateLazyReferences.initialise(elasticInstanceSchedule.getElasticImageConfiguration());
        }
    }

    public static void initialise(@Nullable ElasticAgentDefinition elasticAgentDefinition) {
        if (elasticAgentDefinition != null) {
            HibernateLazyReferences.initialise(elasticAgentDefinition.getElasticImageConfiguration());
        }
    }

    public static void initialiseImageConfigurations(@NotNull Iterable<ElasticImageConfiguration> elasticImageConfigurations) {
        for (ElasticImageConfiguration elasticImageConfiguration : elasticImageConfigurations) {
            HibernateLazyReferences.initialise(elasticImageConfiguration);
        }
    }

    public static void initialiseAgents(@NotNull Iterable<ElasticAgentDefinition> elasticAgents) {
        for (ElasticAgentDefinition elasticAgent : elasticAgents) {
            HibernateLazyReferences.initialise(elasticAgent);
        }
    }
}

