/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@ExperimentalApi
@Internal
public class HibernateRunner {
    private static final Logger logger = Logger.getLogger(HibernateRunner.class);

    public static <T> T runWithHibernateSession(Callable<T> delegate) throws Exception {
        logger.debug((Object)"Opening single Hibernate Session in HibernateRunner");
        SessionFactory sessionFactory = (SessionFactory)ContainerManager.getComponent((String)"sessionFactory", SessionFactory.class);
        Preconditions.checkState((TransactionSynchronizationManager.getResource((Object)sessionFactory) == null ? 1 : 0) != 0, (Object)"Found a session holder");
        HibernateTemplate hibernateTemplate = (HibernateTemplate)ComponentAccessor.HIBERNATE_TEMPLATE.get();
        return HibernateRunner.executeWithBoundSession(hibernateTemplate, delegate, sessionFactory);
    }

    private static <T> T executeWithBoundSession(HibernateTemplate hibernateTemplate, Callable<T> delegate, SessionFactory sessionFactory) {
        return (T)hibernateTemplate.executeWithNativeSession(session -> {
            SessionHolder holder = new SessionHolder(session);
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)holder);
            try {
                Object result;
                Object v = result = delegate.call();
                return v;
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            finally {
                TransactionSynchronizationManager.unbindResource((Object)sessionFactory);
            }
        });
    }
}

