/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class ResettableTableHiLoGenerator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String MAX_LO = "max_lo";
    private static final Logger log = Logger.getLogger(ResettableTableHiLoGenerator.class);
    private long hi;
    private int lo;
    private int maxLo;
    private Class<?> returnClass;
    private static Set<Integer> areExportablesRegistered = new HashSet<Integer>();
    private static volatile boolean isConfigured;
    private static final SequenceStyleGenerator delegate;

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        params.setProperty("value_column", "next_hi");
        params.setProperty("sequence_name", "hibernate_unique_key");
        params.setProperty("force_table_use", Boolean.TRUE.toString());
        if (!isConfigured) {
            delegate.configure(type, params, serviceRegistry);
            isConfigured = true;
        }
        this.maxLo = ConfigurationHelper.getInt((String)MAX_LO, (Map)params, (int)Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }

    public synchronized Serializable generate(SharedSessionContractImplementor session, Object obj) throws HibernateException {
        if (this.lo > this.maxLo) {
            long hival = ((Number)delegate.generate(session, obj)).longValue();
            this.lo = 1;
            this.hi = hival * (long)(this.maxLo + 1);
            log.debug((Object)("new hi value: " + hival));
        }
        return ResettableTableHiLoGenerator.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }

    public synchronized void reset() {
        this.lo = this.maxLo + 1;
    }

    public String[] sqlCreateStrings(Dialect dialect) {
        String[] createTableStatements = delegate.sqlCreateStrings(dialect);
        for (int i = 0; i < createTableStatements.length; ++i) {
            String createTableStatement = createTableStatements[i];
            if (!createTableStatement.startsWith(dialect.getCreateTableString())) continue;
            createTableStatements[i] = createTableStatement + dialect.getTableTypeString();
            break;
        }
        return createTableStatements;
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return delegate.sqlDropStrings(dialect);
    }

    public Object generatorKey() {
        return delegate.generatorKey();
    }

    public void registerExportables(Database database) {
        int databaseHash = System.identityHashCode(database);
        if (areExportablesRegistered.add(databaseHash)) {
            log.info((Object)"Registering exportables...");
            delegate.registerExportables(database);
            Optional<Table> generatorTable = StreamSupport.stream(database.getNamespaces().spliterator(), false).map(Namespace::getTables).flatMap(Collection::stream).filter(n -> n.getName().contains("hibernate")).findAny();
            log.info((Object)("Generator table: " + generatorTable.orElse(null)));
        }
    }

    private static Number createNumber(long value, Class<?> clazz) throws IdentifierGenerationException {
        if (clazz == Long.class) {
            return value;
        }
        if (clazz == Integer.class) {
            return (int)value;
        }
        if (clazz == Short.class) {
            return (short)value;
        }
        throw new IdentifierGenerationException("This ID generator generates long, integer, short");
    }

    public int getMaxLo() {
        return this.maxLo;
    }

    static {
        delegate = new SequenceStyleGenerator();
    }
}

