/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister;

import com.atlassian.bamboo.hibernate.HibernateEntityObject;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogEntry;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.google.common.base.Strings;
import java.util.Date;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NamedQueries(value={@NamedQuery(name="auditLogsForExport", query="SELECT l.id,           l.entityId,           l.childId,           l.timestamp,           l.message,           l.oldValue,           l.newValue,           l.messageType,           l.fieldHeader,           l.entityType,           l.username,           l.fieldType      FROM AuditLogMessage l")})
@Entity
@Table(name="AUDIT_LOG", indexes={@Index(columnList="ENTITY_ID,MSG_TIME_STAMP", name="entity_time_idx")})
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="AUDIT_ID"))
public class AuditLogMessage
extends HibernateEntityObject
implements AuditLogEntry {
    private static final int MAX_LEN = 255;
    @Column(name="MSG_TIME_STAMP")
    private Long timestamp;
    @Column(name="ENTITY_TYPE")
    @Type(type="com.atlassian.bamboo.persister.AuditLogEntityTypeUserType")
    private AuditLogEntityType entityType;
    @Column(name="ENTITY_ID")
    private String entityId;
    @Column(name="CHILD_ID")
    private String childId;
    @Column(name="FIELD_TYPE")
    @Type(type="com.atlassian.bamboo.persister.AuditLogEntityTypeUserType")
    private AuditLogEntityType fieldType;
    @Column(name="MSG_TYPE")
    private String messageType;
    @Column(name="MSG", length=4000)
    @Access(value=AccessType.FIELD)
    private String message;
    @Column(name="USER_NAME")
    private String username;
    @Column(name="OLD_VALUE")
    private String oldValue;
    @Column(name="NEW_VALUE")
    private String newValue;
    @Column(name="FIELD_HEADER")
    private String fieldHeader;

    public AuditLogMessage() {
    }

    @Deprecated
    public AuditLogMessage(@Nullable String username, @NotNull Date timestamp, @Nullable String planKey, @Nullable AuditLogEntity entity, @NotNull String messageType, @NotNull String message, @Nullable String oldValue, @Nullable String newValue) {
        this(username, timestamp, null, planKey, null, entity, messageType, message, oldValue, newValue);
    }

    public AuditLogMessage(@Nullable String username, @NotNull Date timestamp, @Nullable AuditLogEntityType entityType, @Nullable String entityId, @Nullable String childId, @Nullable AuditLogEntity field, @NotNull String messageType, @NotNull String message, @Nullable String oldValue, @Nullable String newValue) {
        this.username = username;
        this.timestamp = timestamp.getTime();
        this.messageType = messageType;
        this.message = message;
        this.oldValue = BambooStringUtils.truncateAndAddEllipsisToLengthInBytes((String)oldValue, (int)255);
        this.newValue = BambooStringUtils.truncateAndAddEllipsisToLengthInBytes((String)newValue, (int)255);
        this.entityType = entityType;
        this.entityId = entityId;
        this.childId = childId;
        if (field != null) {
            this.fieldType = field.getType();
            this.fieldHeader = BambooStringUtils.truncateAndAddEllipsisToLengthInBytes((String)field.getHeader(), (int)255);
        }
    }

    @NotNull
    public Long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public Date getDate() {
        return new Date(this.getTimestamp());
    }

    protected void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Nullable
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String planKey) {
        this.entityId = planKey;
    }

    @Nullable
    public String getChildId() {
        return this.childId;
    }

    public void setChildId(String childId) {
        this.childId = childId;
    }

    @NotNull
    public String getMessageType() {
        return this.messageType;
    }

    protected void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @NotNull
    public String getMessage() {
        return Strings.nullToEmpty((String)this.message);
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    protected void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    protected void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    protected void setUsername(String username) {
        this.username = username;
    }

    public String getFieldHeader() {
        return this.fieldHeader;
    }

    protected void setFieldHeader(String fieldHeader) {
        this.fieldHeader = fieldHeader;
    }

    public AuditLogEntityType getEntityType() {
        return this.entityType;
    }

    protected void setEntityType(AuditLogEntityType entityType) {
        this.entityType = entityType;
    }

    public AuditLogEntityType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(AuditLogEntityType fieldType) {
        this.fieldType = fieldType;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 47).append((Object)this.message).append((Object)this.messageType).append((Object)this.entityId).append((Object)this.entityType).append((Object)this.childId).append((Object)this.timestamp).append((Object)this.username).append((Object)this.fieldHeader).append((Object)this.fieldType).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AuditLogMessage)) {
            return false;
        }
        AuditLogMessage rhs = (AuditLogMessage)((Object)o);
        return new EqualsBuilder().append((Object)this.message, (Object)rhs.message).append((Object)this.messageType, (Object)rhs.messageType).append((Object)this.entityId, (Object)rhs.entityId).append((Object)this.entityType, (Object)rhs.entityType).append((Object)this.timestamp, (Object)rhs.timestamp).append((Object)this.username, (Object)rhs.username).append((Object)this.oldValue, (Object)rhs.oldValue).append((Object)this.newValue, (Object)rhs.newValue).append((Object)this.fieldHeader, (Object)rhs.fieldHeader).append((Object)this.fieldType, (Object)rhs.fieldType).append((Object)this.childId, (Object)rhs.childId).isEquals();
    }

    public int compareTo(Object obj) {
        AuditLogMessage o = (AuditLogMessage)((Object)obj);
        return new CompareToBuilder().append((Object)this.message, (Object)o.message).append((Object)this.messageType, (Object)o.messageType).append((Object)this.entityId, (Object)o.entityId).append((Object)this.timestamp, (Object)o.timestamp).append((Object)this.username, (Object)o.username).append((Object)this.oldValue, (Object)o.oldValue).append((Object)this.newValue, (Object)o.newValue).append((Object)this.fieldHeader, (Object)o.fieldHeader).append((Object)this.entityType, (Object)o.entityType).append((Object)this.fieldType, (Object)o.fieldType).toComparison();
    }

    public String toString() {
        return (this.entityId != null ? this.entityId : "System") + " audit message: " + this.message;
    }
}

