/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.persister.PersisterException;
import com.atlassian.bamboo.persister.file.BuildPersisterDecorator;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedBuildPersisterDecorator
implements BuildPersisterDecorator {
    private final BuildPersisterDecorator myParent;
    private final LoadingCache<PlanResultKey, Optional<BuildResults>> buildResultsCache = CacheBuilder.newBuilder().maximumSize((long)SystemProperty.BUILD_RESULTS_CACHE_SIZE.getValue(100)).build((CacheLoader)new CacheLoader<PlanResultKey, Optional<BuildResults>>(){

        public Optional<BuildResults> load(@NotNull PlanResultKey key) throws Exception {
            return Optional.ofNullable(CachedBuildPersisterDecorator.this.myParent.loadBuildResults((Key)key.getPlanKey(), key.getBuildNumber()));
        }
    });
    private boolean active;

    public CachedBuildPersisterDecorator(BuildPersisterDecorator parent) {
        this.myParent = parent;
    }

    public synchronized void start() throws Exception {
        this.active = true;
        this.myParent.start();
    }

    public synchronized void stop() throws Exception {
        this.myParent.stop();
        this.buildResultsCache.invalidateAll();
        this.active = false;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    @Override
    public void deleteBuildResults(PlanKey planKey, long buildNumber) throws PersisterException {
        this.myParent.deleteBuildResults(planKey, buildNumber);
        this.buildResultsCache.invalidate((Object)PlanKeys.getPlanResultKey((PlanKey)planKey, (int)((int)buildNumber)));
    }

    @Override
    public void saveBuildResults(PlanKey planKey, BuildResults buildResults) throws PersisterException {
        this.myParent.saveBuildResults(planKey, buildResults);
        this.buildResultsCache.invalidate((Object)PlanKeys.getPlanResultKey((PlanKey)planKey, (int)buildResults.getBuildNumber()));
    }

    @Override
    @Nullable
    public BuildResults loadBuildResults(Key planKey, int buildNumber) throws PersisterException {
        return ((Optional)this.buildResultsCache.getUnchecked((Object)PlanKeys.getPlanResultKey((String)planKey.getKey(), (int)buildNumber))).orElse(null);
    }
}

