/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.TaskModuleDescriptor;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class TaskAuditLogHelper {
    public static String getTaskHeader(TaskManager taskManager, @NotNull TaskDefinition taskDefinition) {
        StringBuilder sb = new StringBuilder();
        TaskModuleDescriptor taskModuleDescriptor = taskManager.getTaskDescriptor(taskDefinition.getPluginKey());
        if (taskModuleDescriptor != null) {
            sb.append(taskModuleDescriptor.getName());
        } else {
            sb.append(taskDefinition.getPluginKey());
        }
        if (!StringUtils.isBlank((CharSequence)taskDefinition.getUserDescription())) {
            sb.append(" (").append(taskDefinition.getUserDescription()).append(")");
        }
        return sb.toString();
    }

    public static void logTaskConfigurationChanges(AuditLogService auditLogService, TaskManager taskManager, AuditLogEntityType entityType, Key key, TaskDefinition taskDefinition, Map<String, String> oldConfiguration, String oldDescription, boolean oldIsEnabled) {
        String taskHeader = TaskAuditLogHelper.getTaskHeader(taskManager, taskDefinition);
        auditLogService.log("userDescription", oldDescription, taskDefinition.getUserDescription(), key, entityType, new AuditLogEntity(AuditLogEntityType.TASK, taskHeader));
        auditLogService.log("isEnabled", Boolean.toString(oldIsEnabled), Boolean.toString(taskDefinition.isEnabled()), key, entityType, new AuditLogEntity(AuditLogEntityType.TASK, taskHeader));
        for (String configKey : taskDefinition.getConfiguration().keySet()) {
            String newValue = (String)taskDefinition.getConfiguration().get(configKey);
            String oldValue = oldConfiguration.get(configKey);
            auditLogService.log(configKey, oldValue, newValue, key, entityType, new AuditLogEntity(AuditLogEntityType.TASK, taskHeader));
        }
    }
}

