/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.trigger.TriggerDefinition;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class TriggerAuditLogHelper {
    private static final String TRIGGER_REMOVED = "Trigger has been removed";
    private static final String TRIGGER_CREATED = "Trigger has been created";

    public static String getTriggerHeader(TriggerDefinition triggerDefinition) {
        StringBuilder sb = new StringBuilder();
        sb.append(triggerDefinition.getName());
        if (!StringUtils.isBlank((CharSequence)triggerDefinition.getUserDescription())) {
            sb.append(" (").append(triggerDefinition.getUserDescription()).append(")");
        }
        return sb.toString();
    }

    public static void logTriggerChanges(AuditLogService auditLogService, Key key, TriggerDefinition oldTriggerDefinition, TriggerDefinition newTriggerDefinition, AuditLogEntityType entityType) {
        AuditLogEntity auditLogEntity = new AuditLogEntity(AuditLogEntityType.TRIGGER, TriggerAuditLogHelper.getTriggerHeader(newTriggerDefinition));
        auditLogService.log("description", oldTriggerDefinition.getUserDescription(), newTriggerDefinition.getUserDescription(), key, entityType, auditLogEntity);
        Map configurationMap = newTriggerDefinition.getConfiguration();
        Map oldConfigurationMap = oldTriggerDefinition.getConfiguration();
        for (Map.Entry entry : configurationMap.entrySet()) {
            String configKey = (String)entry.getKey();
            String oldValue = (String)oldConfigurationMap.get(configKey);
            String newValue = (String)entry.getValue();
            auditLogService.log(configKey, oldValue, newValue, key, entityType, auditLogEntity);
        }
    }

    public static void logTriggerCreation(AuditLogService auditLogService, Key key, TriggerDefinition triggerDefinition, AuditLogEntityType entityType) {
        auditLogService.log(TRIGGER_CREATED, key, entityType, new AuditLogEntity(AuditLogEntityType.TRIGGER, TriggerAuditLogHelper.getTriggerHeader(triggerDefinition)));
    }

    public static void logTriggerRemoval(AuditLogService auditLogService, Key key, TriggerDefinition triggerDefinition, AuditLogEntityType entityType) {
        auditLogService.log(TRIGGER_REMOVED, key, entityType, new AuditLogEntity(AuditLogEntityType.TRIGGER, TriggerAuditLogHelper.getTriggerHeader(triggerDefinition)));
    }
}

