/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.file;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.UnconfigurableFeatureDefaults;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationImpl;
import com.atlassian.bamboo.persister.CachedBuildPersisterDecorator;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.persister.PersisterException;
import com.atlassian.bamboo.persister.file.BuildPersisterDecorator;
import com.atlassian.bamboo.persister.file.FileBasedPersisterOptions;
import com.atlassian.bamboo.persister.file.PersisterOptions;
import com.atlassian.bamboo.persister.file.XStreamBuildPersister;
import com.atlassian.bamboo.persister.xstream.XStreamAdminConfigPersister;
import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FileBasedPersister
implements Persister {
    private static final Logger log = Logger.getLogger(FileBasedPersister.class);
    public static final String ADMIN_CONFIG_FILE = "administration.xml";
    public static final String DEFAULT_BUILD_DIRECTORY = "xml-data" + File.separator + "builds";
    public static final String DEFAULT_CONFIG_DIRECTORY = "xml-data" + File.separator + "configuration";
    private String myConfigurationDataDirectory = DEFAULT_CONFIG_DIRECTORY;
    private String myBuildDataDirectory = DEFAULT_BUILD_DIRECTORY;
    private AdministrationConfiguration myAdministrationConfiguration;
    private BuildPersisterDecorator myBuildPersisterDecorator;
    private boolean active;
    private final XStreamFactory xStreamFactory;

    public FileBasedPersister(XStreamFactory xStreamFactory) {
        this.xStreamFactory = xStreamFactory;
    }

    public FileBasedPersister(BootstrapManager bootstrapManager, XStreamFactory xStreamFactory) {
        this.xStreamFactory = xStreamFactory;
        if (bootstrapManager != null) {
            this.setDataDirectory(bootstrapManager.getBuildDirectory());
            this.setConfigurationDirectory(bootstrapManager.getConfigDirectory());
        } else {
            log.warn((Object)"BootstrapManager is null, file persister not initalized properly");
        }
    }

    public void setPersisterOptions(PersisterOptions persisterOptions) {
        FileBasedPersisterOptions fileBasedPersisterOptions = (FileBasedPersisterOptions)persisterOptions;
        this.myConfigurationDataDirectory = fileBasedPersisterOptions.getConfigurationDirectory();
        this.myBuildDataDirectory = fileBasedPersisterOptions.getDataDirectory();
    }

    public String getName() {
        return "File Persister";
    }

    public String getUrl() {
        return "http://www.atlassian.com/bamboo";
    }

    public void setDataDirectory(String buildDataDirectory) {
        this.myBuildDataDirectory = buildDataDirectory;
    }

    public String getDataDirectory() {
        return this.myBuildDataDirectory;
    }

    public File getDataDirectoryFile() {
        return new File(this.myBuildDataDirectory);
    }

    public void setConfigurationDirectory(String configurationDataDirectory) {
        this.myConfigurationDataDirectory = configurationDataDirectory;
    }

    public String getConfigurationDirectory() {
        return this.myConfigurationDataDirectory;
    }

    public File getConfigurationDirectoryFile() {
        return new File(this.myConfigurationDataDirectory);
    }

    public synchronized void start() throws Exception {
        this.active = true;
    }

    public synchronized void stop() throws Exception {
        this.getBuildDecorator().stop();
        this.myBuildPersisterDecorator = null;
        this.active = false;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public void reload() {
        try {
            this.stop();
            this.start();
        }
        catch (Exception e) {
            log.error((Object)"Failed to restart", (Throwable)e);
        }
    }

    public void clear() {
        this.myAdministrationConfiguration = null;
    }

    @VisibleForTesting
    BuildPersisterDecorator getBuildDecorator() {
        if (this.myBuildPersisterDecorator == null) {
            this.myBuildPersisterDecorator = new CachedBuildPersisterDecorator(new XStreamBuildPersister((StorageLocationService)ComponentAccessor.STORAGE_LOCATION_SERVICE.get(), this.xStreamFactory));
        }
        return this.myBuildPersisterDecorator;
    }

    public boolean isInitialised() {
        this.reloadAdministrationConfiguration();
        return this.myAdministrationConfiguration != null;
    }

    public void reloadAdministrationConfiguration() {
        try {
            XStreamAdminConfigPersister xStreamAdminConfigPersister = new XStreamAdminConfigPersister(this.myConfigurationDataDirectory, this.xStreamFactory.createXStream());
            this.myAdministrationConfiguration = xStreamAdminConfigPersister.loadConfiguation();
        }
        catch (PersisterException e) {
            log.error((Object)"Could not load administration configuration from XML", (Throwable)e);
            this.myAdministrationConfiguration = null;
        }
    }

    public AdministrationConfiguration getAdministrationConfiguration() {
        FeatureManager featureManager = ContainerManager.isContainerSetup() ? (FeatureManager)ComponentAccessor.FEATURE_MANAGER.get() : null;
        return this.getAdministrationConfiguration(featureManager);
    }

    public AdministrationConfiguration getAdministrationConfiguration(@Nullable FeatureManager featureManager) {
        UnconfigurableFeatureDefaults unconfigurableFeatureDefaults;
        UnconfigurableFeatureDefaults unconfigurableFeatureDefaults2 = unconfigurableFeatureDefaults = featureManager != null ? featureManager.getUnconfigurableFeatureDefaults() : null;
        if (this.myAdministrationConfiguration != null) {
            this.myAdministrationConfiguration.setUnconfigurableFeatureDefaults(unconfigurableFeatureDefaults);
        } else if (!this.isInitialised()) {
            this.myAdministrationConfiguration = new AdministrationConfigurationImpl(unconfigurableFeatureDefaults);
        }
        return this.myAdministrationConfiguration;
    }

    public void saveAdministrationConfiguration(AdministrationConfiguration administrationConfiguration) {
        XsrfUtils.assertCanPerformMutativeAction("AdministrationConfiguration modification not allowed");
        this.getConfigurationDirectoryFile().mkdirs();
        try {
            XStreamAdminConfigPersister xStreamAdminConfigPersister = new XStreamAdminConfigPersister(this.myConfigurationDataDirectory, this.xStreamFactory.createXStream());
            xStreamAdminConfigPersister.saveConfiguration(administrationConfiguration);
        }
        catch (PersisterException e) {
            log.error((Object)"Failed to save administration configuraton data", (Throwable)e);
        }
    }

    public void deleteBuildResults(PlanKey planKey, long buildNumber) {
        try {
            this.getBuildDecorator().deleteBuildResults(planKey, buildNumber);
        }
        catch (PersisterException e) {
            log.fatal((Object)("Failed to delete build build results for build = \"" + planKey + "\" build " + buildNumber), (Throwable)e);
        }
    }

    public void addBuildResults(PlanKey planKey, BuildResults buildResults) {
        try {
            this.getBuildDecorator().saveBuildResults(planKey, buildResults);
        }
        catch (PersisterException e) {
            log.fatal((Object)("Failed to add build build resultsfor build = \"" + planKey + "\" build \" + buildNumber, e "));
        }
    }

    @Nullable
    public BuildResults getBuildResults(Key planKey, int buildNumber) {
        try {
            return this.getBuildDecorator().loadBuildResults(planKey, buildNumber);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to load build " + planKey + "-" + buildNumber), (Throwable)e);
            return null;
        }
    }
}

