/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.file;

import com.atlassian.bamboo.persister.file.PersisterOptions;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FileBasedPersisterOptions
implements PersisterOptions {
    private String myConfigurationDataDirectory;
    private String myBuildDataDirectory;

    public FileBasedPersisterOptions(String configurationDataDirectory, String buildDataDirectory) {
        this.myConfigurationDataDirectory = configurationDataDirectory;
        this.myBuildDataDirectory = buildDataDirectory;
    }

    public void setDataDirectory(String buildDataDirectory) {
        this.myBuildDataDirectory = StringUtils.trim((String)buildDataDirectory);
    }

    public String getDataDirectory() {
        return this.myBuildDataDirectory;
    }

    public void setConfigurationDirectory(String configurationDataDirectory) {
        this.myConfigurationDataDirectory = StringUtils.trim((String)configurationDataDirectory);
    }

    public String getConfigurationDirectory() {
        return this.myConfigurationDataDirectory;
    }

    public ErrorCollection validate(boolean validateContents) {
        File configFile;
        File buildsFile;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isEmpty((CharSequence)this.myBuildDataDirectory)) {
            errorCollection.addError("filePersister.dataDirectory", "Please specify the build's Data directory");
        } else if (validateContents && !(buildsFile = new File(this.getDataDirectoryFile(), "builds.xml")).exists()) {
            errorCollection.addError("filePersister.dataDirectory", "This does not contain any Bamboo build data.");
        }
        if (StringUtils.isEmpty((CharSequence)this.myConfigurationDataDirectory)) {
            errorCollection.addError("filePersister.configurationDirectory", "Please specify the build's Configuration directory");
        } else if (validateContents && !(configFile = new File(this.getConfigurationDirectoryFile(), "administration.xml")).exists()) {
            errorCollection.addError("filePersister.configurationDirectory", "This does not contain valid Bamboo configuration data.");
        }
        return errorCollection;
    }

    public File getConfigurationDirectoryFile() {
        return new File(this.myConfigurationDataDirectory);
    }

    public File getDataDirectoryFile() {
        return new File(this.myBuildDataDirectory);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }
}

