/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.file;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.container.Startable;
import com.atlassian.bamboo.persister.PersisterException;
import com.atlassian.bamboo.persister.file.BuildPersisterDecorator;
import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.storage.location.BuildPathUtils;
import com.atlassian.bamboo.utils.BambooFiles;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XStreamBuildPersister
implements BuildPersisterDecorator,
Startable {
    private static final Logger log = Logger.getLogger(XStreamBuildPersister.class);
    private volatile boolean active;
    private final StorageLocationService storageLocationService;
    private final XStreamFactory xStreamFactory;

    public XStreamBuildPersister(StorageLocationService storageLocationService, XStreamFactory xStreamFactory) {
        this.storageLocationService = storageLocationService;
        this.xStreamFactory = xStreamFactory;
    }

    public void start() {
        this.active = true;
    }

    public void stop() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void saveBuildResults(PlanKey planKey, BuildResults buildResults) throws PersisterException {
        File buildDirectoryFile = this.storageLocationService.getBuildResultsDirectory((Key)planKey);
        String buildResultXmlFileName = BuildPathUtils.getBuildResultsFilename(buildResults.getBuildNumber());
        buildDirectoryFile.mkdirs();
        Map customBuildData = buildResults.getCustomBuildData();
        buildResults.setCustomBuildData(null);
        File xmlFile = new File(buildDirectoryFile, buildResultXmlFileName);
        try (FileOutputStream xmlOutputStream = new FileOutputStream(xmlFile);){
            this.xStreamFactory.createXStream().toXML((Object)buildResults, (OutputStream)xmlOutputStream);
        }
        catch (Exception e) {
            throw new PersisterException("Error occurred saving build results xStream file", e);
        }
        finally {
            buildResults.setCustomBuildData(customBuildData);
        }
    }

    @Override
    @Nullable
    public BuildResults loadBuildResults(Key planKey, int buildNumber) throws PersisterException {
        File buildResultsFile = this.getBuildResultsFile(buildNumber, planKey);
        if (buildResultsFile == null || !buildResultsFile.exists()) {
            return null;
        }
        try {
            String fileContents = FileUtils.readFileToString((File)buildResultsFile);
            XStream xStream = this.xStreamFactory.createXStream();
            BuildResults buildResults = (BuildResults)xStream.fromXML(fileContents);
            buildResults.setBuildKey(planKey.getKey());
            return buildResults;
        }
        catch (Exception e) {
            throw new PersisterException("Could not load build results : " + planKey + "-" + buildNumber, e);
        }
    }

    @NotNull
    private File getBuildResultsFile(long buildNumber, Key key) {
        File buildDirectoryFile = this.storageLocationService.getBuildResultsDirectory(key);
        String buildResultXmlFileName = BuildPathUtils.getBuildResultsFilename(buildNumber);
        return new File(buildDirectoryFile, buildResultXmlFileName);
    }

    @Override
    public void deleteBuildResults(PlanKey planKey, long buildNumber) throws PersisterException {
        try {
            File buildResultsFile = this.getBuildResultsFile(buildNumber, (Key)planKey);
            if (buildResultsFile.exists()) {
                try {
                    BambooFiles.delete((Path)buildResultsFile.toPath());
                }
                catch (Exception e) {
                    log.warn((Object)("Could not delete the build file: build \"" + planKey + "\" build = \"" + buildNumber + "\" file = \"" + buildResultsFile.getAbsolutePath() + "\""));
                }
            }
        }
        catch (Exception e) {
            throw new PersisterException("Failed to remove build " + buildNumber, e);
        }
    }
}

