/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.xstream;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.persister.XStreamObjectPersister;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXStreamPersister<K extends Key, V>
implements XStreamObjectPersister<K, V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractXStreamPersister.class);
    private static final Charset STORAGE_CHARSET = StandardCharsets.UTF_8;
    private final XStream xStream;
    private final Supplier<File> storageDirectorySupplier;
    private final Function<? super V, K> keyGenerator;
    private final Class<V> persistedClass;

    protected AbstractXStreamPersister(XStream xStream, Supplier<File> storageDirectorySupplier, Function<? super V, K> keyGenerator, Class<V> persistedClass) {
        this.xStream = xStream;
        this.storageDirectorySupplier = storageDirectorySupplier;
        this.keyGenerator = keyGenerator;
        this.persistedClass = persistedClass;
        xStream.processAnnotations(persistedClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public V load(@NotNull K key) {
        log.debug("Loading {} for {}", (Object)this.persistedClass.getName(), key);
        File storageFile = this.storageFile(key);
        try {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(storageFile), STORAGE_CHARSET);
            try {
                Object object = this.xStream.fromXML((Reader)in);
                return (V)object;
            }
            finally {
                Closeables.closeQuietly((Reader)in);
            }
        }
        catch (FileNotFoundException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull V objectToBePersisted, boolean saveEvenIfFileExists) {
        Key key = (Key)this.keyGenerator.apply(objectToBePersisted);
        File storageFile = this.storageFile(key);
        if (storageFile.exists() && !saveEvenIfFileExists) {
            log.debug("Not persisting {} for {}", (Object)this.persistedClass.getName(), (Object)key);
            return;
        }
        log.debug("Persisting {} for {}", (Object)this.persistedClass.getName(), (Object)key);
        File tmpFile = this.temporaryFile(key);
        try {
            BufferedWriter out = new BufferedWriter((Writer)new FileWriterWithEncoding(tmpFile, STORAGE_CHARSET));
            try {
                this.xStream.toXML(objectToBePersisted, (Writer)out);
            }
            finally {
                Closeables.close((Closeable)out, (boolean)true);
            }
            Files.move((File)tmpFile, (File)storageFile);
        }
        catch (Exception t) {
            log.warn("Exception caught while persisting {} for {} - cleaning persister state", new Object[]{this.persistedClass.getName(), key, t});
            this.cleanStorage();
        }
        finally {
            BambooFileUtils.deleteQuietly(tmpFile);
        }
    }

    public void remove(@NotNull K key) {
        log.debug("Removing %s data file for %s", (Object)this.persistedClass.getName(), key);
        BambooFileUtils.deleteQuietly(this.temporaryFile(key));
        BambooFileUtils.deleteQuietly(this.storageFile(key));
    }

    public void cleanStorage() {
        File storageDirectory = this.storageDirectorySupplier.get();
        try {
            BambooFileUtils.cleanDirectory(storageDirectory);
        }
        catch (IOException ignored) {
            log.warn("Storage directory {} couldn't be cleaned", (Object)storageDirectory.getAbsolutePath());
        }
    }

    @NotNull
    public Iterable<Pair<K, V>> loadAndRemoveAll() {
        File storageDirectory = this.storageDirectorySupplier.get();
        Function<File, Pair> objectLoader = file -> {
            try {
                Pair pair;
                Throwable throwable;
                InputStreamReader in;
                block17: {
                    block18: {
                        in = new InputStreamReader((InputStream)new FileInputStream((File)file), STORAGE_CHARSET);
                        throwable = null;
                        Object value = this.xStream.fromXML((Reader)in);
                        Key key = (Key)this.keyGenerator.apply(value);
                        pair = Pair.make((Object)key, (Object)value);
                        if (in == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            ((Reader)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    ((Reader)in).close();
                }
                return pair;
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (in != null) {
                                if (throwable != null) {
                                    try {
                                        ((Reader)in).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    ((Reader)in).close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception while restoring server state from " + file.getName(), (Throwable)e);
                    }
                }
            }
            finally {
                BambooFileUtils.deleteQuietly(file);
            }
            return null;
        };
        return Arrays.stream(storageDirectory.listFiles()).map(objectLoader).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected File temporaryFile(@NotNull K key) {
        return new File(this.storageDirectorySupplier.get(), String.format("%s.xml.tmp", key.getKey()));
    }

    protected File storageFile(@NotNull K key) {
        return new File(this.storageDirectorySupplier.get(), String.format("%s.xml", key.getKey()));
    }
}

