/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.xstream;

import com.atlassian.bamboo.crypto.BouncyCastleProviderUtils;
import com.atlassian.bamboo.persister.xstream.XStreamUtils;
import com.atlassian.bamboo.security.trustedapplications.BambooCurrentApplication;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class BambooCurrentApplicationConverter
implements Converter {
    private static final String ASYM_ALGORITHM = "RSA";
    private static final String PROPERTY_APPLICATION_ID = "applicationId";
    private static final String PROPERTY_PUBLIC_KEY = "publicKey";
    private static final String PROPERTY_PRIVATE_KEY = "privateKey";
    private final KeyFactory keyFactory;

    public BambooCurrentApplicationConverter() {
        try {
            this.keyFactory = KeyFactory.getInstance(ASYM_ALGORITHM, BouncyCastleProviderUtils.getProviderName());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalStateException(e);
        }
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        BambooCurrentApplication bambooCurrentApplication = (BambooCurrentApplication)source;
        XStreamUtils.writeNode(writer, PROPERTY_APPLICATION_ID, bambooCurrentApplication.getApplicationId());
        KeyPair keyPair = bambooCurrentApplication.getKeyPair();
        this.writeKey(writer, keyPair.getPublic(), PROPERTY_PUBLIC_KEY);
        this.writeKey(writer, keyPair.getPrivate(), PROPERTY_PRIVATE_KEY);
    }

    private void writeKey(HierarchicalStreamWriter writer, Key key, String nodeName) {
        XStreamUtils.writeNode(writer, nodeName, Base64.getEncoder().encodeToString(key.getEncoded()));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String appId = null;
        String privateKey = null;
        String publicKey = null;
        while (reader.hasMoreChildren()) {
            Pair<String, String> node = XStreamUtils.readNextChildNodeValue(reader);
            String nodeName = (String)node.getLeft();
            String nodeValue = (String)node.getRight();
            if (nodeName.equals(PROPERTY_APPLICATION_ID)) {
                appId = nodeValue;
                continue;
            }
            if (nodeName.equals(PROPERTY_PUBLIC_KEY)) {
                publicKey = nodeValue;
                continue;
            }
            if (nodeName.equals(PROPERTY_PRIVATE_KEY)) {
                privateKey = nodeValue;
                continue;
            }
            throw new IllegalArgumentException("Unknown node: [" + nodeName + '/' + nodeValue + ']');
        }
        Preconditions.checkNotNull(appId);
        Preconditions.checkNotNull(privateKey);
        Preconditions.checkNotNull(publicKey);
        return new BambooCurrentApplication(appId, this.toKeyPair(privateKey, publicKey));
    }

    @NotNull
    private KeyPair toKeyPair(@NotNull String privateKeyStr, @NotNull String publicKeyStr) {
        try {
            PublicKey publicKey = this.createPublicKey(publicKeyStr);
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKeyStr));
            PrivateKey privateKey = this.keyFactory.generatePrivate(privKeySpec);
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private PublicKey createPublicKey(String publicKeyStr) throws InvalidKeySpecException {
        if (publicKeyStr.contains("RSA Public Key")) {
            return this.generateRSAPublicKeyFromToString(publicKeyStr);
        }
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyStr));
        return this.keyFactory.generatePublic(pubKeySpec);
    }

    @VisibleForTesting
    PublicKey generateRSAPublicKeyFromToString(String publicKeyStr) {
        BigInteger modulus = BambooCurrentApplicationConverter.getModulus(publicKeyStr);
        BigInteger exponent = BambooCurrentApplicationConverter.getExponent(publicKeyStr);
        try {
            return this.keyFactory.generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Unable to parse key: [" + publicKeyStr + ']', e);
        }
    }

    private static BigInteger getExponent(String publicKeyStr) {
        String exponentStr = StringUtils.substringAfter((String)publicKeyStr, (String)"exponent: ").trim();
        return new BigInteger(exponentStr, 16);
    }

    private static BigInteger getModulus(String publicKeyStr) {
        String modulusStr = StringUtils.substringBefore((String)StringUtils.substringAfter((String)publicKeyStr, (String)"modulus: "), (String)"\n").trim();
        return new BigInteger(modulusStr, 16);
    }

    public boolean canConvert(Class type) {
        return BambooCurrentApplication.class.equals((Object)type);
    }
}

