/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.xstream;

import com.atlassian.bamboo.ReasonForBuild;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfigurationImpl;
import com.atlassian.bamboo.agent.elastic.server.SpotInstanceConfig;
import com.atlassian.bamboo.build.BuildOutputLogEntry;
import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.SimpleLogEntry;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.configuration.AdministrationConfigurationImpl;
import com.atlassian.bamboo.configuration.Jdk;
import com.atlassian.bamboo.configuration.ScheduleBackupConfiguration;
import com.atlassian.bamboo.persister.xstream.BambooCurrentApplicationConverter;
import com.atlassian.bamboo.persister.xstream.BambooDateTimeConverter;
import com.atlassian.bamboo.persister.xstream.BuildStateConverter;
import com.atlassian.bamboo.persister.xstream.DeploymentResultKeyImplConverter;
import com.atlassian.bamboo.persister.xstream.SecondsDateConverter;
import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.persister.xstream.XStreamInitializer;
import com.atlassian.bamboo.persister.xstream.XWorkListConverter;
import com.atlassian.bamboo.repository.LegacyRepositoryDataImpl;
import com.atlassian.bamboo.results.BuildResultsImpl;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultErrorImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultImpl;
import com.atlassian.bamboo.serialization.xstream.OptionalCommitFilesXStreamConverter;
import com.atlassian.bamboo.utils.xstream.converters.ConverterFactory;
import com.atlassian.bamboo.utils.xstream.converters.PeriodConverter;
import com.atlassian.bamboo.utils.xstream.mappers.MapperFactory;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinitionImpl;
import com.atlassian.bamboo.xmpp.SmackXmppMessageSender;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizableXStreamFactory
implements XStreamFactory {
    private static final Map<String, Class<?>> HIBERNATE3_ALIASES = ImmutableMap.builder().put((Object)"org.hibernate.collection.PersistentBag", ArrayList.class).put((Object)"org.hibernate.collection.PersistentList", ArrayList.class).put((Object)"org.hibernate.collection.PersistentMap", HashMap.class).put((Object)"org.hibernate.collection.PersistentSet", HashSet.class).put((Object)"org.hibernate.collection.PersistentSortedMap", TreeMap.class).put((Object)"org.hibernate.collection.PersistentSortedSet", TreeSet.class).build();
    private static final Map<String, Class<?>> HIBERNATE2_ALIASES = ImmutableMap.builder().put((Object)"net.sf.hibernate.collection.Bag", ArrayList.class).put((Object)"net.sf.hibernate.collection.List", ArrayList.class).put((Object)"net.sf.hibernate.collection.Map", HashMap.class).put((Object)"net.sf.hibernate.collection.Set", HashSet.class).put((Object)"net.sf.hibernate.collection.SortedMap", TreeMap.class).put((Object)"net.sf.hibernate.collection.SortedSet", TreeSet.class).build();
    private final Iterable<MapperFactory> customMappers;
    private final Iterable<ConverterFactory> customConverters;
    private final Iterable<XStreamInitializer> customInitializers;
    private final Map<String, Class<?>> customAliases;

    private static Iterable<MapperFactory> defaultCustomMappers() {
        return Collections.emptyList();
    }

    private static Iterable<ConverterFactory> defaultCustomConverters() {
        return Collections.emptyList();
    }

    private static Iterable<XStreamInitializer> defaultCustomInitializers() {
        return ImmutableList.of((Object)DefaultConverterInitializer.INSTANCE);
    }

    private static Map<String, Class<?>> defaultCustomAliases() {
        return ImmutableMap.builder().put((Object)"BuildState", BuildState.class).put((Object)"BuildResults", BuildResultsImpl.class).put((Object)"ReasonForBuild", ReasonForBuild.class).put((Object)"scheduleBackupConfiguration", ScheduleBackupConfiguration.class).put((Object)"AdministrationConfiguration", AdministrationConfigurationImpl.class).put((Object)"TestResults", TestResults.class).put((Object)"TestResultError", TestCaseResultErrorImpl.class).put((Object)"JdkPathMap", Jdk.class).put((Object)"SmackXmppMessageSender", SmackXmppMessageSender.class).put((Object)"SimpleLogEntry", SimpleLogEntry.class).put((Object)"ErrorLogEntry", ErrorLogEntry.class).put((Object)"CommandLogEntry", CommandLogEntry.class).put((Object)"BuildOutputLogEntry", BuildOutputLogEntry.class).put((Object)"spotInstanceConfig", SpotInstanceConfig.class).putAll(HIBERNATE2_ALIASES).putAll(HIBERNATE3_ALIASES).build();
    }

    public CustomizableXStreamFactory(@NotNull Iterable<MapperFactory> customMappers, @NotNull Iterable<ConverterFactory> customConverters, @NotNull Iterable<XStreamInitializer> customInitializers, @NotNull Map<String, Class<?>> customAliases) {
        this.customMappers = Iterables.concat(customMappers, CustomizableXStreamFactory.defaultCustomMappers());
        this.customConverters = Iterables.concat(customConverters, CustomizableXStreamFactory.defaultCustomConverters());
        this.customInitializers = Iterables.concat(customInitializers, CustomizableXStreamFactory.defaultCustomInitializers());
        this.customAliases = ImmutableMap.builder().putAll(customAliases).putAll(CustomizableXStreamFactory.defaultCustomAliases()).build();
    }

    public CustomizableXStreamFactory() {
        this.customMappers = CustomizableXStreamFactory.defaultCustomMappers();
        this.customConverters = CustomizableXStreamFactory.defaultCustomConverters();
        this.customInitializers = CustomizableXStreamFactory.defaultCustomInitializers();
        this.customAliases = CustomizableXStreamFactory.defaultCustomAliases();
    }

    @Override
    @NotNull
    public XStream createXStream() {
        CustomXStream xStream = new CustomXStream();
        this.init(xStream);
        return xStream;
    }

    @Override
    @NotNull
    public XStream createXStream(ClassLoader classLoader) {
        XStream xStream = this.createXStream();
        this.setClassLoader(xStream, classLoader);
        return xStream;
    }

    @Override
    @NotNull
    public XStream createCompactXStream() {
        CustomXStream xStream = new CustomXStream((HierarchicalStreamDriver)new CompactXpp3Driver());
        this.init(xStream);
        return xStream;
    }

    private void init(XStream xStream) {
        this.applyConverters(xStream);
        this.applyInitializers(xStream);
        this.registerAliases(xStream);
        this.processLocalConverters(xStream);
    }

    private void processLocalConverters(XStream xStream) {
        xStream.registerLocalConverter(CommitImpl.class, "files", (Converter)new OptionalCommitFilesXStreamConverter(xStream));
        xStream.registerLocalConverter(CommitContextImpl.class, "files", (Converter)new OptionalCommitFilesXStreamConverter(xStream));
    }

    private void applyConverters(XStream xStream) {
        for (ConverterFactory converterFactory : this.customConverters) {
            xStream.registerConverter(converterFactory.createConverter(xStream));
        }
    }

    private void applyInitializers(XStream xStream) {
        for (XStreamInitializer initializer : this.customInitializers) {
            initializer.initialize(xStream);
        }
    }

    private void registerAliases(XStream xStream) {
        for (Map.Entry<String, Class<?>> alias : this.customAliases.entrySet()) {
            xStream.alias(alias.getKey(), alias.getValue());
        }
    }

    private void setClassLoader(XStream xStream, @Nullable ClassLoader loader) {
        if (loader == null) {
            return;
        }
        ClassLoader current = xStream.getClassLoader();
        if (current instanceof CompositeClassLoader) {
            ((CompositeClassLoader)CompositeClassLoader.class.cast(current)).add(loader);
        } else {
            xStream.setClassLoader(loader);
        }
    }

    private static final class DefaultConverterInitializer
    implements XStreamInitializer {
        static final DefaultConverterInitializer INSTANCE = new DefaultConverterInitializer();

        private DefaultConverterInitializer() {
        }

        @Override
        public void initialize(XStream xStream) {
            xStream.registerConverter((SingleValueConverter)new SecondsDateConverter());
            xStream.registerConverter((SingleValueConverter)new BambooDateTimeConverter());
            xStream.registerConverter((Converter)new BuildStateConverter());
            xStream.registerConverter((Converter)new BambooCurrentApplicationConverter());
            xStream.registerConverter((SingleValueConverter)new DeploymentResultKeyImplConverter());
            xStream.registerConverter((SingleValueConverter)new PeriodConverter());
            xStream.processAnnotations(LegacyRepositoryDataImpl.class);
            xStream.processAnnotations(VcsLocationDefinitionImpl.class);
            xStream.processAnnotations(TestResults.class);
            xStream.processAnnotations(TestClassResultImpl.class);
            Converter arrayListConverter = xStream.getConverterLookup().lookupConverterForType(ArrayList.class);
            xStream.registerConverter((Converter)new XWorkListConverter(arrayListConverter));
            xStream.addDefaultImplementation(ElasticConfigurationImpl.class, ElasticConfiguration.class);
        }
    }

    private class CustomXStream
    extends XStream {
        CustomXStream() {
            this.ignoreUnknownElements();
        }

        CustomXStream(HierarchicalStreamDriver driver) {
            super(driver);
            this.ignoreUnknownElements();
        }

        protected MapperWrapper wrapMapper(MapperWrapper mapperToWrap) {
            MapperWrapper mapper = mapperToWrap;
            for (MapperFactory factory : CustomizableXStreamFactory.this.customMappers) {
                mapper = factory.createMapper(mapper);
            }
            return mapper;
        }
    }

    private static class CompactXpp3Driver
    extends Xpp3Driver {
        private CompactXpp3Driver() {
        }

        public HierarchicalStreamWriter createWriter(Writer out) {
            return new CompactWriter(out, this.getNameCoder());
        }
    }
}

