/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.xstream;

import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.persister.xstream.XStreamManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.thoughtworks.xstream.XStream;
import java.io.OutputStream;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultXStreamManager
implements XStreamManager {
    private final PluginAccessor pluginAccessor;
    private final PluginEventManager pluginEventManager;
    private final XStreamFactory xStreamFactory;
    private XStream global;
    private PluginXStreams pluginXStreams;

    public static DefaultXStreamManager getNonPluginAwareInstance(XStreamFactory xStreamFactory) {
        return new DefaultXStreamManager(xStreamFactory);
    }

    public DefaultXStreamManager(@NotNull PluginAccessor pluginAccessor, @Nullable PluginEventManager pluginEventManager, @NotNull XStreamFactory xStreamFactory) {
        this.xStreamFactory = xStreamFactory;
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
    }

    private DefaultXStreamManager(@NotNull XStreamFactory xStreamFactory) {
        this.xStreamFactory = xStreamFactory;
        this.pluginAccessor = null;
        this.pluginEventManager = null;
    }

    @PostConstruct
    @VisibleForTesting
    public void postConstruct() {
        this.global = this.xStreamFactory.createXStream();
        this.pluginXStreams = this.pluginAccessor != null ? new PluginXStreams(new PluginXStreamInitializer(this.pluginAccessor, this.xStreamFactory, this.global)) : new PluginXStreams(new NonPluginAwareInitializer(this.global));
        if (this.pluginEventManager != null) {
            this.pluginEventManager.register((Object)this.pluginXStreams);
        }
    }

    @Override
    public Object fromXML(String xml) {
        return this.global.fromXML(xml);
    }

    @Override
    public Object fromXML(String pluginKey, String serializedData) {
        return this.pluginXStreams.getXStream(pluginKey).fromXML(serializedData);
    }

    @Override
    public String toXML(Object object) {
        return this.global.toXML(object);
    }

    @Override
    public void toXML(Object object, OutputStream outputStream) {
        this.global.toXML(object, outputStream);
    }

    private static final class NonPluginAwareInitializer
    implements Function<String, XStream> {
        private final XStream fallBack;

        public NonPluginAwareInitializer(XStream fallBack) {
            this.fallBack = fallBack;
        }

        public XStream apply(String pluginKey) {
            return this.fallBack;
        }
    }

    private static final class PluginXStreamInitializer
    implements Function<String, XStream> {
        private final PluginAccessor pluginAccessor;
        private final XStreamFactory xStreamFactory;
        private final XStream fallBack;

        public PluginXStreamInitializer(PluginAccessor pluginAccessor, XStreamFactory xStreamFactory, XStream fallBack) {
            this.pluginAccessor = pluginAccessor;
            this.xStreamFactory = xStreamFactory;
            this.fallBack = fallBack;
        }

        public XStream apply(String pluginKey) {
            Plugin plugin = this.getPlugin(pluginKey);
            return plugin != null ? this.xStreamFactory.createXStream(plugin.getClassLoader()) : this.fallBack;
        }

        private Plugin getPlugin(String pluginKey) {
            return this.pluginAccessor != null ? this.pluginAccessor.getPlugin(pluginKey) : null;
        }
    }

    public static final class PluginXStreams {
        private final LoadingCache<String, XStream> pluginXStreams;

        PluginXStreams(Function<String, XStream> initializer) {
            this.pluginXStreams = CacheBuilder.newBuilder().weakValues().build(CacheLoader.from(initializer));
        }

        XStream getXStream(String pluginKey) {
            return (XStream)this.pluginXStreams.getUnchecked((Object)pluginKey);
        }

        Iterable<XStream> allXStreams() {
            return this.pluginXStreams.asMap().values();
        }

        @EventListener
        public void onPluginUninstalled(PluginUninstalledEvent pluginUninstalledEvent) {
            this.resetXStream(pluginUninstalledEvent.getPlugin().getKey());
        }

        @EventListener
        public void onPluginEnabled(PluginEnabledEvent pluginEnabledEvent) {
            this.resetXStream(pluginEnabledEvent.getPlugin().getKey());
        }

        private void resetXStream(String key) {
            this.pluginXStreams.invalidate((Object)key);
        }
    }
}

