/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.xstream;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RelativePath {
    private RelativePath() {
    }

    public static String getRelativePath(File homeDirectory, File fileToMakeRelative) {
        if (homeDirectory.equals(fileToMakeRelative)) {
            return "";
        }
        return RelativePath.matchPathLists(RelativePath.getPathElements(homeDirectory), RelativePath.getPathElements(fileToMakeRelative));
    }

    public static List getPathElements(File file) {
        ArrayList<String> pathElements = new ArrayList<String>();
        try {
            for (File r = file.getCanonicalFile(); r != null; r = r.getParentFile()) {
                pathElements.add(r.getName());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get the path elements for " + file, e);
        }
        return pathElements;
    }

    private static String matchPathLists(List homePath, List pathToFile) {
        int numFilePathElements;
        StringBuilder relativePath = new StringBuilder();
        int numOfHomePathElements = homePath.size() - 1;
        for (numFilePathElements = pathToFile.size() - 1; numOfHomePathElements >= 0 && numFilePathElements >= 0 && homePath.get(numOfHomePathElements).equals(pathToFile.get(numFilePathElements)); --numOfHomePathElements, --numFilePathElements) {
        }
        while (numOfHomePathElements >= 0) {
            relativePath.append("..").append(File.separator);
            --numOfHomePathElements;
        }
        while (numFilePathElements >= 1) {
            relativePath.append(pathToFile.get(numFilePathElements)).append(File.separator);
            --numFilePathElements;
        }
        relativePath.append(pathToFile.get(numFilePathElements));
        return relativePath.toString();
    }
}

