/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister.xstream;

import com.atlassian.bamboo.persister.xstream.XStreamFactory;
import com.atlassian.bamboo.persister.xstream.XStreamUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.xstream.converters.ConverterFactory;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SecureXStreamFactory
implements XStreamFactory {
    private static final Logger log = Logger.getLogger(SecureXStreamFactory.class);
    private final XStreamFactory xStreamFactory;
    private final TypePermission securityProvider;
    private final List<ConverterFactory> customConverters;

    public SecureXStreamFactory(XStreamFactory xStreamFactory, TypePermission securityProvider) {
        this(xStreamFactory, securityProvider, new ArrayList<ConverterFactory>());
    }

    public SecureXStreamFactory(XStreamFactory xStreamFactory, TypePermission securityProvider, List<ConverterFactory> customConverters) {
        this.xStreamFactory = xStreamFactory;
        this.securityProvider = securityProvider;
        this.customConverters = customConverters;
    }

    @Override
    @NotNull
    public XStream createXStream() {
        XStream xStream = this.xStreamFactory.createXStream();
        this.secureXStream(xStream);
        return xStream;
    }

    @Override
    @NotNull
    public XStream createXStream(@Nullable ClassLoader classLoader) {
        XStream xStream = this.xStreamFactory.createXStream(classLoader);
        this.secureXStream(xStream);
        return xStream;
    }

    @Override
    @NotNull
    public XStream createCompactXStream() {
        XStream xStream = this.xStreamFactory.createCompactXStream();
        this.secureXStream(xStream);
        return xStream;
    }

    private void secureXStream(XStream xStream) {
        if (!SystemProperty.DISABLE_SERIALIZATION_SECURITY.getTypedValue()) {
            xStream.addPermission(NoTypePermission.NONE);
            xStream.addPermission(this.securityProvider);
            this.applyConverters(xStream);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)String.format("System property %s prevents securing XStream instance", SystemProperty.DISABLE_SERIALIZATION_SECURITY.getKey()));
        }
    }

    private void applyConverters(XStream xStream) {
        xStream.registerConverter((Converter)new PermissionBasedConverter(this.securityProvider), 10000);
        for (ConverterFactory converterFactory : this.customConverters) {
            xStream.registerConverter(converterFactory.createConverter(xStream));
        }
    }

    private static class PermissionBasedConverter
    implements Converter {
        private final TypePermission typePermission;

        private PermissionBasedConverter(TypePermission typePermission) {
            this.typePermission = typePermission;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            String className = source == null ? "null" : source.getClass().toString();
            log.warn((Object)("[" + className + "] at " + XStreamUtils.getPath(writer) + " won't be marshalled"));
        }

        @Nullable
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            log.warn((Object)String.format("Class is not allowed to be unmarshalled, returning null for node '%s' with value '%s' of class %s within object of class %s", reader.getNodeName(), reader.getValue(), context.getRequiredType(), this.getCurrentObjectClassName(context)));
            return null;
        }

        private String getCurrentObjectClassName(UnmarshallingContext context) {
            if (context != null && context.currentObject() != null) {
                return context.currentObject().getClass().getName();
            }
            return "null";
        }

        public boolean canConvert(Class type) {
            return !this.typePermission.allows(type);
        }
    }
}

